/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.common.animation;

import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.tysontheember.apertureapi.InterpolationMath;
import org.joml.Vector2f;

public class TimeBezierController {
    private static final Vector2f ZERO = new Vector2f();
    private static final Vector2f ONE = new Vector2f(1.0f, 1.0f);
    private static final Vector2f V_CACHE = new Vector2f();
    private final Vector2f left;
    private final Vector2f right;

    public TimeBezierController(Vector2f left, Vector2f right) {
        this.left = left;
        this.right = right;
    }

    public TimeBezierController() {
        this(new Vector2f(0.4f, 0.4f), new Vector2f(0.6f, 0.6f));
    }

    public Vector2f getLeft() {
        return this.left;
    }

    public void setLeft(float x, float y) {
        this.left.set(x, y);
    }

    public Vector2f getRight() {
        return this.right;
    }

    public void setRight(float x, float y) {
        this.right.set(x, y);
    }

    public float interpolate(float f) {
        return InterpolationMath.bezier((float)f, (Vector2f)TimeBezierController.ZERO, (Vector2f)this.left, (Vector2f)this.right, (Vector2f)TimeBezierController.ONE, (Vector2f)TimeBezierController.V_CACHE).y;
    }

    public void easy() {
        this.left.set(0.25f, 0.1f);
        this.right.set(0.25f, 1.0f);
    }

    public void easyIn() {
        this.left.set(0.42f, 0.0f);
        this.right.set(1.0f, 1.0f);
    }

    public void easyOut() {
        this.left.set(0.0f, 0.0f);
        this.right.set(0.58f, 1.0f);
    }

    public void easyInOut() {
        this.left.set(0.42f, 0.0f);
        this.right.set(0.58f, 1.0f);
    }

    public static ListTag toNBT(TimeBezierController controller) {
        ListTag root = new ListTag();
        root.add((Object)FloatTag.m_128566_((float)controller.left.x));
        root.add((Object)FloatTag.m_128566_((float)controller.left.y));
        root.add((Object)FloatTag.m_128566_((float)controller.right.x));
        root.add((Object)FloatTag.m_128566_((float)controller.right.y));
        return root;
    }

    public static TimeBezierController fromNBT(ListTag root) {
        return new TimeBezierController(new Vector2f(root.m_128775_(0), root.m_128775_(1)), new Vector2f(root.m_128775_(2), root.m_128775_(3)));
    }
}

