/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.common.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.tysontheember.apertureapi.client.network.ClientPayloadManager;
import net.tysontheember.apertureapi.client.preview.JsonCameraPreview;
import net.tysontheember.apertureapi.common.ModNetwork;
import net.tysontheember.apertureapi.common.animation.GlobalCameraPath;
import net.tysontheember.apertureapi.common.data_entity.GlobalCameraPathInfo;
import net.tysontheember.apertureapi.common.network.C2SPayloadManager;

public record S2CPayloadReply(CompoundTag tag) {
    private static final HashMap<String, BiFunction<CompoundTag, NetworkEvent.Context, CompoundTag>> HANDLERS = new HashMap();

    public static void encode(S2CPayloadReply pag, FriendlyByteBuf buf) {
        buf.m_130079_(pag.tag);
    }

    public static S2CPayloadReply decode(FriendlyByteBuf bug) {
        return new S2CPayloadReply(bug.m_130260_());
    }

    public static void handle(S2CPayloadReply payload, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            String key = payload.tag.m_128461_("key");
            BiFunction<CompoundTag, NetworkEvent.Context, CompoundTag> handler = HANDLERS.get(key);
            if (handler == null) {
                return;
            }
            CompoundTag result = handler.apply(payload.tag.m_128469_("value"), context);
            if (result == null) {
                return;
            }
            CompoundTag root = new CompoundTag();
            root.m_128359_("key", key);
            root.m_128365_("value", (Tag)result);
            ModNetwork.INSTANCE.reply((Object)new C2SPayloadManager(root), context);
        });
        context.setPacketHandled(true);
    }

    static {
        HANDLERS.put("checkGlobalPath", (tag, context) -> {
            ArrayList<GlobalCameraPathInfo> paths;
            boolean succeed = tag.m_128471_("succeed");
            if (succeed) {
                paths = new ArrayList<GlobalCameraPathInfo>();
                ListTag list = tag.m_128437_("paths", 10);
                for (int i = 0; i < list.size(); ++i) {
                    paths.add(GlobalCameraPathInfo.fromNBT(list.m_128728_(i)));
                }
            } else {
                paths = null;
            }
            ClientPayloadManager.INSTANCE.checkGlobalPath(tag.m_128451_("page"), tag.m_128451_("size"), succeed, (List<GlobalCameraPathInfo>)paths, (NetworkEvent.Context)context);
            return null;
        });
        HANDLERS.put("putGlobalPath", (tag, context) -> {
            ClientPayloadManager.INSTANCE.putGlobalPath(tag.m_128471_("succeed"), (NetworkEvent.Context)context);
            return null;
        });
        HANDLERS.put("removeGlobalPath", (tag, context) -> {
            ClientPayloadManager.INSTANCE.removeGlobalPath(tag.m_128471_("succeed"), (NetworkEvent.Context)context);
            return null;
        });
        HANDLERS.put("getGlobalPath", (tag, context) -> {
            boolean succeed = tag.m_128471_("succeed");
            GlobalCameraPath path = succeed ? GlobalCameraPath.fromNBT(tag.m_128469_("path")) : null;
            ClientPayloadManager.INSTANCE.getGlobalPath(path, succeed, tag.m_128451_("receiver"), (NetworkEvent.Context)context);
            return null;
        });
        HANDLERS.put("getNativePath", (tag, context) -> {
            Entity entity;
            GlobalCameraPath path;
            boolean succeed = tag.m_128471_("succeed");
            if (succeed) {
                path = GlobalCameraPath.fromNBT(tag.m_128469_("path"));
                entity = Minecraft.m_91087_().f_91073_.m_6815_(tag.m_128451_("center"));
            } else {
                path = null;
                entity = null;
            }
            ClientPayloadManager.INSTANCE.getNativePath(path, entity, succeed, (NetworkEvent.Context)context);
            return null;
        });
        HANDLERS.put("playJsonPath", (tag, context) -> {
            String id = tag.m_128461_("id");
            JsonCameraPreview.start(id);
            return null;
        });
        HANDLERS.put("stopCamera", (tag, context) -> {
            ClientPayloadManager.INSTANCE.stopCamera((NetworkEvent.Context)context);
            return null;
        });
        HANDLERS.put("resetCamera", (tag, context) -> {
            ClientPayloadManager.INSTANCE.resetCamera((NetworkEvent.Context)context);
            return null;
        });
    }
}

