/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.common.security;

import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tysontheember.apertureapi.CommonConf;

@Mod.EventBusSubscriber(modid="apertureapi")
public enum DamageGuard {
    INSTANCE;

    private final HashSet<UUID> playing = new HashSet();
    private final HashMap<UUID, Long> graceUntil = new HashMap();

    public CompoundTag onClientCutsceneState(ServerPlayer player, boolean isPlaying) {
        CompoundTag out = new CompoundTag();
        if (player == null) {
            return out;
        }
        ServerLevel level = player.m_284548_();
        long now = level.m_46467_();
        if (isPlaying) {
            this.playing.add(player.m_20148_());
            this.graceUntil.remove(player.m_20148_());
        } else {
            this.playing.remove(player.m_20148_());
            int grace = (Integer)CommonConf.CUTSCENE_POST_GRACE_TICKS.get();
            if (grace > 0) {
                this.graceUntil.put(player.m_20148_(), now + (long)grace);
            }
        }
        return out;
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)livingEntity;
        if (!((Boolean)CommonConf.CUTSCENE_INVULNERABLE.get()).booleanValue()) {
            return;
        }
        if (INSTANCE.isProtected(sp)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAttack(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)livingEntity;
        if (!((Boolean)CommonConf.CUTSCENE_INVULNERABLE.get()).booleanValue()) {
            return;
        }
        if (INSTANCE.isProtected(sp)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            UUID id = sp.m_20148_();
            DamageGuard.INSTANCE.playing.remove(id);
            DamageGuard.INSTANCE.graceUntil.remove(id);
        }
    }

    private boolean isProtected(ServerPlayer sp) {
        UUID id = sp.m_20148_();
        if (this.playing.contains(id)) {
            return true;
        }
        Long until = this.graceUntil.get(id);
        if (until == null) {
            return false;
        }
        long now = sp.m_284548_().m_46467_();
        if (now <= until) {
            return true;
        }
        this.graceUntil.remove(id);
        return false;
    }
}

