/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.path;

import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class ArcLengthLUT {
    private final float[] t;
    private final float[] s;
    private final float totalLength;

    public ArcLengthLUT(Evaluator f, int samples) {
        int i;
        if (samples < 2) {
            samples = 2;
        }
        this.t = new float[samples];
        this.s = new float[samples];
        Vector3f a = new Vector3f();
        Vector3f b = new Vector3f();
        float accum = 0.0f;
        for (i = 0; i < samples; ++i) {
            float tt;
            this.t[i] = tt = (float)i / (float)(samples - 1);
            f.eval(tt, b);
            if (i == 0) {
                this.s[i] = 0.0f;
                a.set((Vector3fc)b);
                continue;
            }
            this.s[i] = accum += a.distance((Vector3fc)b);
            a.set((Vector3fc)b);
        }
        this.totalLength = accum;
        if (this.totalLength <= 1.0E-6f) {
            for (i = 0; i < samples; ++i) {
                this.s[i] = 0.0f;
            }
        }
    }

    public float totalLength() {
        return this.totalLength;
    }

    public float tForDistance(float d) {
        if (d <= 0.0f || this.totalLength <= 1.0E-6f) {
            return 0.0f;
        }
        if (d >= this.totalLength) {
            return 1.0f;
        }
        int lo = 0;
        int hi = this.s.length - 1;
        while (lo + 1 < hi) {
            int mid = lo + hi >>> 1;
            if (this.s[mid] < d) {
                lo = mid;
                continue;
            }
            hi = mid;
        }
        float segLen = this.s[hi] - this.s[lo];
        if (segLen <= 1.0E-6f) {
            return this.t[lo];
        }
        float alpha = (d - this.s[lo]) / segLen;
        return this.t[lo] + (this.t[hi] - this.t[lo]) * alpha;
    }

    public float distanceForT(float tt) {
        if (tt <= 0.0f) {
            return 0.0f;
        }
        if (tt >= 1.0f) {
            return this.totalLength;
        }
        float d = tt * (float)(this.s.length - 1);
        int i = (int)Math.floor(d);
        int j = Math.min(i + 1, this.s.length - 1);
        float frac = d - (float)i;
        return this.s[i] + (this.s[j] - this.s[i]) * frac;
    }

    @FunctionalInterface
    public static interface Evaluator {
        public Vector3f eval(float var1, Vector3f var2);
    }
}

