/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.path;

import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class CatmullRom {
    private CatmullRom() {
    }

    public static Vector3f eval(float t, Vector3f p0, Vector3f p1, Vector3f p2, Vector3f p3, float alpha, Vector3f out) {
        if (t <= 0.0f) {
            return out.set((Vector3fc)p1);
        }
        if (t >= 1.0f) {
            return out.set((Vector3fc)p2);
        }
        alpha = CatmullRom.clamp(alpha, 0.0f, 1.0f);
        float t01 = (float)Math.pow(CatmullRom.dist(p0, p1), alpha);
        float t12 = (float)Math.pow(CatmullRom.dist(p1, p2), alpha);
        float t23 = (float)Math.pow(CatmullRom.dist(p2, p3), alpha);
        if (t01 < 1.0E-6f) {
            t01 = 1.0E-6f;
        }
        if (t12 < 1.0E-6f) {
            t12 = 1.0E-6f;
        }
        if (t23 < 1.0E-6f) {
            t23 = 1.0E-6f;
        }
        float invT01 = 1.0f / t01;
        float invT12 = 1.0f / t12;
        float invT23 = 1.0f / t23;
        Vector3f term1 = new Vector3f((Vector3fc)p1).sub((Vector3fc)p0).mul(invT01);
        Vector3f term2 = new Vector3f((Vector3fc)p2).sub((Vector3fc)p0).mul(1.0f / (t01 + t12));
        Vector3f term3 = new Vector3f((Vector3fc)p2).sub((Vector3fc)p1).mul(invT12);
        Vector3f m1 = term1.sub((Vector3fc)term2).add((Vector3fc)term3);
        m1.mul(1.0f * t12);
        term1.set((Vector3fc)p2).sub((Vector3fc)p1).mul(invT12);
        term2.set((Vector3fc)p3).sub((Vector3fc)p1).mul(1.0f / (t12 + t23));
        term3.set((Vector3fc)p3).sub((Vector3fc)p2).mul(invT23);
        Vector3f m2 = term1.sub((Vector3fc)term2).add((Vector3fc)term3);
        m2.mul(1.0f * t12);
        float t2 = t * t;
        float t3 = t2 * t;
        float h00 = 2.0f * t3 - 3.0f * t2 + 1.0f;
        float h10 = t3 - 2.0f * t2 + t;
        float h01 = -2.0f * t3 + 3.0f * t2;
        float h11 = t3 - t2;
        return out.set((Vector3fc)new Vector3f((Vector3fc)p1).mul(h00).add((Vector3fc)new Vector3f((Vector3fc)m1).mul(h10)).add((Vector3fc)new Vector3f((Vector3fc)p2).mul(h01)).add((Vector3fc)new Vector3f((Vector3fc)m2).mul(h11)));
    }

    private static float dist(Vector3f a, Vector3f b) {
        float dx = b.x - a.x;
        float dy = b.y - a.y;
        float dz = b.z - a.z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private static float clamp(float v, float lo, float hi) {
        return v < lo ? lo : (v > hi ? hi : v);
    }
}

