/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.path;

import java.util.List;
import net.tysontheember.apertureapi.path.PathInterpolationEngine;
import net.tysontheember.apertureapi.path.PathModel;
import net.tysontheember.apertureapi.path.interpolation.EasingType;
import net.tysontheember.apertureapi.path.interpolation.InterpolationType;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PathEvaluator {
    public static EvaluationResult evaluateAtTime(PathModel path, float timeSeconds) {
        float globalT;
        List<PathModel.Segment> segments = path.getSegments();
        if (segments.size() < 2) {
            return PathEvaluator.createDefaultResult(segments.isEmpty() ? null : segments.get(0));
        }
        if (path.getSpeed().isSpeedMode()) {
            float blocksPerSec = path.getSpeed().blocksPerSec.floatValue();
            float arcLength = timeSeconds * blocksPerSec;
            globalT = path.getArcLengthLUT().arcLengthToParameter(arcLength);
        } else {
            float totalDuration = path.getSpeed().durationSec;
            globalT = Math.max(0.0f, Math.min(1.0f, timeSeconds / totalDuration));
        }
        return PathEvaluator.evaluateAtParameter(path, globalT);
    }

    public static EvaluationResult evaluateAtParameter(PathModel path, float globalT) {
        List<PathModel.Segment> segments = path.getSegments();
        if (segments.size() < 2) {
            return PathEvaluator.createDefaultResult(segments.isEmpty() ? null : segments.get(0));
        }
        globalT = path.isLoop() && globalT >= 1.0f ? (globalT -= (float)Math.floor(globalT)) : Math.max(0.0f, Math.min(1.0f, globalT));
        int numSegments = segments.size() - 1;
        float segmentFloat = globalT * (float)numSegments;
        int segmentIndex = (int)Math.floor(segmentFloat);
        float localT = segmentFloat - (float)segmentIndex;
        if (segmentIndex >= numSegments) {
            segmentIndex = numSegments - 1;
            localT = 1.0f;
        }
        PathModel.Segment current = segments.get(segmentIndex);
        PathModel.Segment next = segments.get(segmentIndex + 1);
        InterpolationType interpType = current.interpolationType != null ? current.interpolationType : path.getDefaults().interpolationType;
        EasingType easingType = current.easingType != null ? current.easingType : path.getDefaults().easingType;
        float easedT = easingType.apply(localT);
        Vector3f position = PathInterpolationEngine.interpolatePosition(current, next, easedT, interpType, segmentIndex, segments);
        Quaternionf orientation = PathInterpolationEngine.interpolateOrientation(current, next, easedT, path.getDefaults().banking, path.getDefaults().bankingStrength);
        float bankingRoll = 0.0f;
        if (path.getDefaults().banking) {
            bankingRoll = PathInterpolationEngine.calculateBankingRoll(current, next, segmentIndex, segments, path.getDefaults().bankingStrength);
        }
        float roll = PathInterpolationEngine.interpolateRoll(current.roll, next.roll, easedT, easingType, bankingRoll, path.getDefaults().rollMix);
        float fov = PathInterpolationEngine.interpolateFOV(current.fov, next.fov, easedT, easingType);
        float speed = PathEvaluator.calculateCurrentSpeed(path, globalT, segmentIndex, localT);
        return new EvaluationResult(position, orientation, roll, fov, speed, segmentIndex, localT);
    }

    public static EvaluationResult evaluateAtArcLength(PathModel path, float arcLength) {
        PathModel.ArcLengthLUT lut = path.getArcLengthLUT();
        float globalT = lut.arcLengthToParameter(arcLength);
        return PathEvaluator.evaluateAtParameter(path, globalT);
    }

    public static float getTotalDuration(PathModel path) {
        if (path.getSpeed().isSpeedMode()) {
            float totalLength = path.getArcLengthLUT().getTotalLength();
            return totalLength / path.getSpeed().blocksPerSec.floatValue();
        }
        return path.getSpeed().durationSec;
    }

    public static float getTotalLength(PathModel path) {
        return path.getArcLengthLUT().getTotalLength();
    }

    public static Vector3f getVelocityAtTime(PathModel path, float timeSeconds) {
        float dt = 0.016f;
        EvaluationResult current = PathEvaluator.evaluateAtTime(path, timeSeconds);
        EvaluationResult next = PathEvaluator.evaluateAtTime(path, timeSeconds + dt);
        return new Vector3f((Vector3fc)next.position).sub((Vector3fc)current.position).div(dt);
    }

    public static Vector3f getVelocityAtParameter(PathModel path, float globalT) {
        float dt = 0.001f;
        EvaluationResult current = PathEvaluator.evaluateAtParameter(path, globalT);
        EvaluationResult next = PathEvaluator.evaluateAtParameter(path, globalT + dt);
        return new Vector3f((Vector3fc)next.position).sub((Vector3fc)current.position).div(dt);
    }

    public static EvaluationResult[] samplePath(PathModel path, int numSamples) {
        EvaluationResult[] samples = new EvaluationResult[numSamples];
        for (int i = 0; i < numSamples; ++i) {
            float t = (float)i / (float)(numSamples - 1);
            samples[i] = PathEvaluator.evaluateAtParameter(path, t);
        }
        return samples;
    }

    public static String getDebugInfo(PathModel path, float timeSeconds) {
        EvaluationResult result = PathEvaluator.evaluateAtTime(path, timeSeconds);
        Vector3f velocity = PathEvaluator.getVelocityAtTime(path, timeSeconds);
        return String.format("Time: %.2fs\nPosition: (%.2f, %.2f, %.2f)\nVelocity: (%.2f, %.2f, %.2f) [%.2f blocks/s]\nRoll: %.2f\u00b0\nFOV: %.1f\u00b0\nSegment: %d (%.2f%%)", Float.valueOf(timeSeconds), Float.valueOf(result.position.x), Float.valueOf(result.position.y), Float.valueOf(result.position.z), Float.valueOf(velocity.x), Float.valueOf(velocity.y), Float.valueOf(velocity.z), Float.valueOf(velocity.length()), Float.valueOf(result.roll), Float.valueOf(result.fov), result.segmentIndex, Float.valueOf(result.segmentProgress * 100.0f));
    }

    private static EvaluationResult createDefaultResult(PathModel.Segment segment) {
        if (segment == null) {
            return new EvaluationResult(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternionf(), 0.0f, 90.0f, 0.0f, 0, 0.0f);
        }
        return new EvaluationResult(new Vector3f((Vector3fc)segment.position), new Quaternionf((Quaternionfc)segment.orientation), segment.roll, segment.fov, 0.0f, 0, 0.0f);
    }

    private static float calculateCurrentSpeed(PathModel path, float globalT, int segmentIndex, float localT) {
        if (path.getSpeed().isSpeedMode()) {
            return path.getSpeed().blocksPerSec.floatValue();
        }
        PathModel.ArcLengthLUT lut = path.getArcLengthLUT();
        float currentArcLength = lut.parameterToArcLength(globalT);
        float dt = 0.001f;
        float nextT = Math.min(1.0f, globalT + dt);
        float nextArcLength = lut.parameterToArcLength(nextT);
        float dsdt = (nextArcLength - currentArcLength) / dt;
        float dtds_time = path.getSpeed().durationSec;
        return dsdt / dtds_time;
    }

    public static PathModel createSimplePath(String id, Vector3f start, Vector3f end, float duration) {
        PathModel path = new PathModel(id, id);
        path.addSegment(new PathModel.Segment(start, 0.0f, 0.0f, 0.0f));
        path.addSegment(new PathModel.Segment(end, 0.0f, 0.0f, 0.0f));
        path.getSpeed().setDurationMode(duration);
        return path;
    }

    public static PathModel createTestPath() {
        PathModel path = new PathModel("test_path", "Test Path");
        path.getDefaults().interpolationType = InterpolationType.CATMULL_CENTRIPETAL;
        path.getDefaults().easingType = EasingType.CUBIC_IN_OUT;
        path.getDefaults().banking = true;
        path.getDefaults().bankingStrength = 0.5f;
        path.addSegment(new PathModel.Segment(new Vector3f(0.0f, 70.0f, 0.0f), 0.0f, 0.0f, 0.0f));
        path.addSegment(new PathModel.Segment(new Vector3f(10.0f, 75.0f, 5.0f), 45.0f, -10.0f, 5.0f));
        path.addSegment(new PathModel.Segment(new Vector3f(20.0f, 73.0f, -2.0f), 90.0f, 0.0f, -5.0f));
        path.addSegment(new PathModel.Segment(new Vector3f(25.0f, 78.0f, 10.0f), 180.0f, 15.0f, 0.0f));
        path.addSegment(new PathModel.Segment(new Vector3f(15.0f, 80.0f, 20.0f), 270.0f, -5.0f, 0.0f));
        path.getSpeed().setDurationMode(10.0f);
        return path;
    }

    public static class EvaluationResult {
        public final Vector3f position;
        public final Quaternionf orientation;
        public final float roll;
        public final float fov;
        public final float speed;
        public final int segmentIndex;
        public final float segmentProgress;

        public EvaluationResult(Vector3f position, Quaternionf orientation, float roll, float fov, float speed, int segmentIndex, float segmentProgress) {
            this.position = position;
            this.orientation = orientation;
            this.roll = roll;
            this.fov = fov;
            this.speed = speed;
            this.segmentIndex = segmentIndex;
            this.segmentProgress = segmentProgress;
        }
    }
}

