/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.path;

import java.util.List;
import net.minecraft.util.Mth;
import net.tysontheember.apertureapi.path.PathModel;
import net.tysontheember.apertureapi.path.interpolation.EasingType;
import net.tysontheember.apertureapi.path.interpolation.InterpolationType;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PathInterpolationEngine {
    public static Vector3f interpolatePosition(PathModel.Segment current, PathModel.Segment next, float localT, InterpolationType type, int segmentIndex, List<PathModel.Segment> allSegments) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case InterpolationType.LINEAR -> PathInterpolationEngine.interpolateLinear(current.position, next.position, localT);
            case InterpolationType.COSINE -> PathInterpolationEngine.interpolateCosine(current.position, next.position, localT);
            case InterpolationType.HERMITE -> PathInterpolationEngine.interpolateHermite(current, next, localT, segmentIndex, allSegments);
            case InterpolationType.BEZIER -> PathInterpolationEngine.interpolateBezier(current, next, localT);
            case InterpolationType.CATMULL_UNIFORM, InterpolationType.CATMULL_CENTRIPETAL, InterpolationType.CATMULL_CHORDAL -> PathInterpolationEngine.interpolateCatmullRom(current, next, localT, type.getCatmullAlpha(), segmentIndex, allSegments);
        };
    }

    public static Quaternionf interpolateOrientation(PathModel.Segment current, PathModel.Segment next, float localT, boolean banking, float bankingStrength) {
        Vector3f velocity;
        Quaternionf result = new Quaternionf();
        current.orientation.slerp((Quaternionfc)next.orientation, localT, result);
        if (banking && bankingStrength > 0.0f && (velocity = new Vector3f((Vector3fc)next.position).sub((Vector3fc)current.position)).lengthSquared() > 1.0E-6f) {
            velocity.normalize();
            Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
            Vector3f right = new Vector3f((Vector3fc)velocity).cross((Vector3fc)up);
            if (right.lengthSquared() > 1.0E-6f) {
                right.normalize();
                float bankAngle = right.dot((Vector3fc)velocity) * bankingStrength * 0.5235988f;
                Quaternionf bankingRotation = new Quaternionf().rotateAxis(bankAngle, (Vector3fc)velocity);
                result.mul((Quaternionfc)bankingRotation);
            }
        }
        return result;
    }

    public static float interpolateFOV(float currentFOV, float nextFOV, float localT, EasingType easing) {
        float easedT = easing.apply(localT);
        return Mth.m_14179_((float)easedT, (float)currentFOV, (float)nextFOV);
    }

    public static float interpolateRoll(float currentRoll, float nextRoll, float localT, EasingType easing, float bankingRoll, float rollMix) {
        float easedT = easing.apply(localT);
        float interpolatedRoll = Mth.m_14179_((float)easedT, (float)currentRoll, (float)nextRoll);
        return Mth.m_14179_((float)rollMix, (float)interpolatedRoll, (float)bankingRoll);
    }

    private static Vector3f interpolateLinear(Vector3f a, Vector3f b, float t) {
        return new Vector3f((Vector3fc)a).lerp((Vector3fc)b, t);
    }

    private static Vector3f interpolateCosine(Vector3f a, Vector3f b, float t) {
        float cosineT = (1.0f - (float)Math.cos((double)t * Math.PI)) * 0.5f;
        return new Vector3f((Vector3fc)a).lerp((Vector3fc)b, cosineT);
    }

    private static Vector3f interpolateHermite(PathModel.Segment current, PathModel.Segment next, float t, int segmentIndex, List<PathModel.Segment> allSegments) {
        Vector3f p0 = current.position;
        Vector3f p1 = next.position;
        Vector3f m0 = PathInterpolationEngine.calculateHermiteTangent(current, segmentIndex, allSegments, true);
        Vector3f m1 = PathInterpolationEngine.calculateHermiteTangent(next, segmentIndex + 1, allSegments, false);
        float t2 = t * t;
        float t3 = t2 * t;
        float h00 = 2.0f * t3 - 3.0f * t2 + 1.0f;
        float h10 = t3 - 2.0f * t2 + t;
        float h01 = -2.0f * t3 + 3.0f * t2;
        float h11 = t3 - t2;
        return new Vector3f((Vector3fc)p0).mul(h00).add((Vector3fc)new Vector3f((Vector3fc)m0).mul(h10)).add((Vector3fc)new Vector3f((Vector3fc)p1).mul(h01)).add((Vector3fc)new Vector3f((Vector3fc)m1).mul(h11));
    }

    private static Vector3f calculateHermiteTangent(PathModel.Segment segment, int index, List<PathModel.Segment> allSegments, boolean incoming) {
        if (allSegments.size() < 2) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        Vector3f tangent = new Vector3f();
        Vector3f prev = index > 0 ? allSegments.get((int)(index - 1)).position : segment.position;
        Vector3f curr = segment.position;
        Vector3f next = index < allSegments.size() - 1 ? allSegments.get((int)(index + 1)).position : segment.position;
        float tension = segment.tension;
        float continuity = segment.continuity;
        float bias = segment.bias;
        Vector3f inTangent = new Vector3f((Vector3fc)curr).sub((Vector3fc)prev);
        Vector3f outTangent = new Vector3f((Vector3fc)next).sub((Vector3fc)curr);
        tangent = incoming ? new Vector3f((Vector3fc)inTangent).mul((1.0f - tension) * (1.0f + continuity) * (1.0f + bias) / 2.0f).add((Vector3fc)new Vector3f((Vector3fc)outTangent).mul((1.0f - tension) * (1.0f - continuity) * (1.0f - bias) / 2.0f)) : new Vector3f((Vector3fc)inTangent).mul((1.0f - tension) * (1.0f + continuity) * (1.0f - bias) / 2.0f).add((Vector3fc)new Vector3f((Vector3fc)outTangent).mul((1.0f - tension) * (1.0f - continuity) * (1.0f + bias) / 2.0f));
        return tangent;
    }

    private static Vector3f interpolateBezier(PathModel.Segment current, PathModel.Segment next, float t) {
        Vector3f p0 = current.position;
        Vector3f p3 = next.position;
        Vector3f p1 = current.bezierOut != null ? new Vector3f((Vector3fc)current.position).add((Vector3fc)current.bezierOut) : new Vector3f((Vector3fc)current.position).lerp((Vector3fc)next.position, 0.33f);
        Vector3f p2 = next.bezierIn != null ? new Vector3f((Vector3fc)next.position).add((Vector3fc)next.bezierIn) : new Vector3f((Vector3fc)next.position).lerp((Vector3fc)current.position, 0.33f);
        float t2 = t * t;
        float t3 = t2 * t;
        float mt = 1.0f - t;
        float mt2 = mt * mt;
        float mt3 = mt2 * mt;
        return new Vector3f((Vector3fc)p0).mul(mt3).add((Vector3fc)new Vector3f((Vector3fc)p1).mul(3.0f * mt2 * t)).add((Vector3fc)new Vector3f((Vector3fc)p2).mul(3.0f * mt * t2)).add((Vector3fc)new Vector3f((Vector3fc)p3).mul(t3));
    }

    private static Vector3f interpolateCatmullRom(PathModel.Segment current, PathModel.Segment next, float t, float alpha, int segmentIndex, List<PathModel.Segment> allSegments) {
        Vector3f p1 = current.position;
        Vector3f p2 = next.position;
        Vector3f p0 = segmentIndex > 0 ? allSegments.get((int)(segmentIndex - 1)).position : new Vector3f((Vector3fc)p1).mul(2.0f).sub((Vector3fc)p2);
        Vector3f p3 = segmentIndex + 2 < allSegments.size() ? allSegments.get((int)(segmentIndex + 2)).position : new Vector3f((Vector3fc)p2).mul(2.0f).sub((Vector3fc)p1);
        return PathInterpolationEngine.evaluateCatmullRom(t, p0, p1, p2, p3, alpha);
    }

    private static Vector3f evaluateCatmullRom(float t, Vector3f p0, Vector3f p1, Vector3f p2, Vector3f p3, float alpha) {
        if (t <= 0.0f) {
            return new Vector3f((Vector3fc)p1);
        }
        if (t >= 1.0f) {
            return new Vector3f((Vector3fc)p2);
        }
        alpha = Math.max(0.0f, Math.min(1.0f, alpha));
        float t01 = (float)Math.pow(p0.distance((Vector3fc)p1), alpha);
        float t12 = (float)Math.pow(p1.distance((Vector3fc)p2), alpha);
        float t23 = (float)Math.pow(p2.distance((Vector3fc)p3), alpha);
        if (t01 < 1.0E-6f) {
            t01 = 1.0E-6f;
        }
        if (t12 < 1.0E-6f) {
            t12 = 1.0E-6f;
        }
        if (t23 < 1.0E-6f) {
            t23 = 1.0E-6f;
        }
        Vector3f a1 = new Vector3f((Vector3fc)p1).sub((Vector3fc)p0).div(t01).sub((Vector3fc)new Vector3f((Vector3fc)p2).sub((Vector3fc)p0).div(t01 + t12)).add((Vector3fc)new Vector3f((Vector3fc)p2).sub((Vector3fc)p1).div(t12)).mul(t12);
        Vector3f a2 = new Vector3f((Vector3fc)p2).sub((Vector3fc)p1).div(t12).sub((Vector3fc)new Vector3f((Vector3fc)p3).sub((Vector3fc)p1).div(t12 + t23)).add((Vector3fc)new Vector3f((Vector3fc)p3).sub((Vector3fc)p2).div(t23)).mul(t12);
        float t2 = t * t;
        float t3 = t2 * t;
        float h00 = 2.0f * t3 - 3.0f * t2 + 1.0f;
        float h10 = t3 - 2.0f * t2 + t;
        float h01 = -2.0f * t3 + 3.0f * t2;
        float h11 = t3 - t2;
        return new Vector3f((Vector3fc)p1).mul(h00).add((Vector3fc)new Vector3f((Vector3fc)a1).mul(h10)).add((Vector3fc)new Vector3f((Vector3fc)p2).mul(h01)).add((Vector3fc)new Vector3f((Vector3fc)a2).mul(h11));
    }

    public static float calculateBankingRoll(PathModel.Segment current, PathModel.Segment next, int segmentIndex, List<PathModel.Segment> allSegments, float bankingStrength) {
        if (allSegments.size() < 3 || bankingStrength <= 0.0f) {
            return 0.0f;
        }
        Vector3f prev = segmentIndex > 0 ? allSegments.get((int)(segmentIndex - 1)).position : current.position;
        Vector3f curr = current.position;
        Vector3f next_pos = next.position;
        Vector3f v1 = new Vector3f((Vector3fc)curr).sub((Vector3fc)prev);
        Vector3f v2 = new Vector3f((Vector3fc)next_pos).sub((Vector3fc)curr);
        if (v1.lengthSquared() < 1.0E-6f || v2.lengthSquared() < 1.0E-6f) {
            return 0.0f;
        }
        v1.normalize();
        v2.normalize();
        Vector3f cross = new Vector3f((Vector3fc)v1).cross((Vector3fc)v2);
        float curvature = cross.length();
        float bankDirection = cross.y;
        float maxBankAngle = 30.0f;
        return Math.signum(bankDirection) * curvature * bankingStrength * maxBankAngle;
    }
}

