/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.path;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.tysontheember.apertureapi.path.PathInterpolationEngine;
import net.tysontheember.apertureapi.path.interpolation.EasingType;
import net.tysontheember.apertureapi.path.interpolation.InterpolationType;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PathModel {
    public static final int VERSION = 2;
    private final String id;
    private final String name;
    private int version = 2;
    private boolean loop = false;
    private final PathDefaults defaults;
    private final SpeedSettings speed;
    private final List<Segment> segments;
    private volatile ArcLengthLUT arcLengthLUT;
    private volatile boolean lutDirty = true;
    private long lastModified;
    private UUID lastModifier;

    public PathModel(String id, String name) {
        this.id = id;
        this.name = name;
        this.defaults = new PathDefaults();
        this.speed = new SpeedSettings();
        this.segments = new ArrayList<Segment>();
        this.lastModified = System.currentTimeMillis();
        this.lastModifier = UUID.fromString("00000000-0000-0000-0000-000000000000");
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public PathDefaults getDefaults() {
        return this.defaults;
    }

    public SpeedSettings getSpeed() {
        return this.speed;
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public UUID getLastModifier() {
        return this.lastModifier;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
        this.markDirty();
    }

    public void setLastModifier(UUID modifier) {
        this.lastModifier = modifier;
        this.lastModified = System.currentTimeMillis();
    }

    public void addSegment(Segment segment) {
        this.segments.add(segment);
        this.markDirty();
    }

    public void insertSegment(int index, Segment segment) {
        this.segments.add(index, segment);
        this.markDirty();
    }

    public void removeSegment(int index) {
        if (index >= 0 && index < this.segments.size()) {
            this.segments.remove(index);
            this.markDirty();
        }
    }

    @Nullable
    public Segment getSegment(int index) {
        return index >= 0 && index < this.segments.size() ? this.segments.get(index) : null;
    }

    private void markDirty() {
        this.lutDirty = true;
        this.lastModified = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArcLengthLUT getArcLengthLUT() {
        if (this.lutDirty || this.arcLengthLUT == null) {
            PathModel pathModel = this;
            synchronized (pathModel) {
                if (this.lutDirty || this.arcLengthLUT == null) {
                    this.arcLengthLUT = this.buildArcLengthLUT();
                    this.lutDirty = false;
                }
            }
        }
        return this.arcLengthLUT;
    }

    private ArcLengthLUT buildArcLengthLUT() {
        if (this.segments.size() < 2) {
            return ArcLengthLUT.empty();
        }
        FloatArrayList parameterValues = new FloatArrayList();
        FloatArrayList arcLengthValues = new FloatArrayList();
        float totalLength = 0.0f;
        parameterValues.add(0.0f);
        arcLengthValues.add(0.0f);
        for (int i = 0; i < this.segments.size() - 1; ++i) {
            Segment current = this.segments.get(i);
            Segment next = this.segments.get(i + 1);
            int samples = this.calculateOptimalSamples(current, next);
            Vector3f prevPos = current.position;
            for (int s = 1; s <= samples; ++s) {
                float t = (float)s / (float)samples;
                float globalT = ((float)i + t) / (float)(this.segments.size() - 1);
                Vector3f currentPos = this.evaluatePositionAt(i, t);
                float segmentLength = prevPos.distance((Vector3fc)currentPos);
                parameterValues.add(globalT);
                arcLengthValues.add(totalLength += segmentLength);
                prevPos = currentPos;
            }
        }
        return new ArcLengthLUT(parameterValues.toFloatArray(), arcLengthValues.toFloatArray(), totalLength);
    }

    private int calculateOptimalSamples(Segment current, Segment next) {
        int baseSamples = 8;
        float distance = current.position.distance((Vector3fc)next.position);
        float curvatureFactor = 1.0f;
        if (this.segments.size() > 2) {
            Vector3f dir1 = new Vector3f((Vector3fc)current.position).sub((Vector3fc)this.getPrevPosition(current));
            Vector3f dir2 = new Vector3f((Vector3fc)next.position).sub((Vector3fc)current.position);
            dir1.normalize();
            dir2.normalize();
            float dot = dir1.dot((Vector3fc)dir2);
            curvatureFactor = (2.0f - dot) / 2.0f;
        }
        int samples = Math.max(baseSamples, (int)((float)baseSamples * (1.0f + distance * 0.1f + curvatureFactor * 2.0f)));
        return Math.min(samples, 64);
    }

    private Vector3f getPrevPosition(Segment segment) {
        int index = this.segments.indexOf(segment);
        return index > 0 ? this.segments.get((int)(index - 1)).position : segment.position;
    }

    private Vector3f evaluatePositionAt(int segmentIndex, float localT) {
        if (segmentIndex < 0 || segmentIndex >= this.segments.size() - 1) {
            return segmentIndex < 0 ? this.segments.get((int)0).position : this.segments.get((int)(this.segments.size() - 1)).position;
        }
        Segment current = this.segments.get(segmentIndex);
        Segment next = this.segments.get(segmentIndex + 1);
        InterpolationType interpType = current.interpolationType != null ? current.interpolationType : this.defaults.interpolationType;
        return PathInterpolationEngine.interpolatePosition(current, next, localT, interpType, segmentIndex, this.segments);
    }

    public JsonObject toJson(Gson gson) {
        JsonObject json = new JsonObject();
        json.addProperty("version", (Number)2);
        json.addProperty("id", this.id);
        json.addProperty("name", this.name);
        json.addProperty("loop", Boolean.valueOf(this.loop));
        JsonObject defaultsObj = new JsonObject();
        defaultsObj.addProperty("interp", this.defaults.interpolationType.getName());
        defaultsObj.addProperty("ease", this.defaults.easingType.getName());
        defaultsObj.addProperty("speedMode", this.defaults.speedMode.name().toLowerCase());
        defaultsObj.addProperty("banking", Boolean.valueOf(this.defaults.banking));
        defaultsObj.addProperty("bankingStrength", (Number)Float.valueOf(this.defaults.bankingStrength));
        defaultsObj.addProperty("rollMix", (Number)Float.valueOf(this.defaults.rollMix));
        json.add("defaults", (JsonElement)defaultsObj);
        JsonObject speedObj = new JsonObject();
        speedObj.addProperty("durationSec", (Number)Float.valueOf(this.speed.durationSec));
        if (this.speed.blocksPerSec != null) {
            speedObj.addProperty("blocksPerSec", (Number)this.speed.blocksPerSec);
        }
        json.add("speed", (JsonElement)speedObj);
        JsonArray segmentsArray = new JsonArray();
        for (Segment segment : this.segments) {
            segmentsArray.add((JsonElement)this.segmentToJson(segment));
        }
        json.add("segments", (JsonElement)segmentsArray);
        json.addProperty("lastModified", (Number)this.lastModified);
        json.addProperty("lastModifier", this.lastModifier.toString());
        return json;
    }

    private JsonObject segmentToJson(Segment segment) {
        JsonObject json = new JsonObject();
        JsonArray pos = new JsonArray();
        pos.add((Number)Float.valueOf(segment.position.x));
        pos.add((Number)Float.valueOf(segment.position.y));
        pos.add((Number)Float.valueOf(segment.position.z));
        json.add("p", (JsonElement)pos);
        JsonObject rot = new JsonObject();
        Vector3f euler = segment.toEulerDegrees();
        rot.addProperty("yaw", (Number)Float.valueOf(euler.y));
        rot.addProperty("pitch", (Number)Float.valueOf(euler.x));
        rot.addProperty("roll", (Number)Float.valueOf(euler.z));
        JsonArray quat = new JsonArray();
        quat.add((Number)Float.valueOf(segment.orientation.x));
        quat.add((Number)Float.valueOf(segment.orientation.y));
        quat.add((Number)Float.valueOf(segment.orientation.z));
        quat.add((Number)Float.valueOf(segment.orientation.w));
        rot.add("q", (JsonElement)quat);
        json.add("rot", (JsonElement)rot);
        json.addProperty("roll", (Number)Float.valueOf(segment.roll));
        json.addProperty("fov", (Number)Float.valueOf(segment.fov));
        if (segment.durationSec != null) {
            json.addProperty("durationSec", (Number)segment.durationSec);
        }
        if (segment.weight != null) {
            json.addProperty("weight", (Number)segment.weight);
        }
        if (segment.interpolationType != null) {
            json.addProperty("interp", segment.interpolationType.getName());
        }
        if (segment.easingType != null) {
            json.addProperty("ease", segment.easingType.getName());
        }
        if (segment.followTarget != null) {
            JsonObject followObj = new JsonObject();
            followObj.addProperty("type", segment.followTarget.type.name().toLowerCase());
            if (segment.followTarget.entityId != null) {
                followObj.addProperty("id", segment.followTarget.entityId.toString());
            }
            if (segment.followTarget.position != null) {
                JsonArray followPos = new JsonArray();
                followPos.add((Number)Float.valueOf(segment.followTarget.position.x));
                followPos.add((Number)Float.valueOf(segment.followTarget.position.y));
                followPos.add((Number)Float.valueOf(segment.followTarget.position.z));
                followObj.add("pos", (JsonElement)followPos);
            }
            followObj.addProperty("followSpeed", (Number)Float.valueOf(segment.followTarget.followSpeed));
            json.add("lookAt", (JsonElement)followObj);
        }
        if (segment.tension != 0.0f || segment.continuity != 0.0f || segment.bias != 0.0f) {
            JsonObject tcb = new JsonObject();
            tcb.addProperty("t", (Number)Float.valueOf(segment.tension));
            tcb.addProperty("c", (Number)Float.valueOf(segment.continuity));
            tcb.addProperty("b", (Number)Float.valueOf(segment.bias));
            json.add("tcb", (JsonElement)tcb);
        }
        if (segment.bezierIn != null || segment.bezierOut != null) {
            JsonObject bezier = new JsonObject();
            if (segment.bezierIn != null) {
                JsonArray inArray = new JsonArray();
                inArray.add((Number)Float.valueOf(segment.bezierIn.x));
                inArray.add((Number)Float.valueOf(segment.bezierIn.y));
                inArray.add((Number)Float.valueOf(segment.bezierIn.z));
                bezier.add("in", (JsonElement)inArray);
            }
            if (segment.bezierOut != null) {
                JsonArray outArray = new JsonArray();
                outArray.add((Number)Float.valueOf(segment.bezierOut.x));
                outArray.add((Number)Float.valueOf(segment.bezierOut.y));
                outArray.add((Number)Float.valueOf(segment.bezierOut.z));
                bezier.add("out", (JsonElement)outArray);
            }
            json.add("bezier", (JsonElement)bezier);
        }
        return json;
    }

    public static PathModel fromJson(JsonObject json, Gson gson) {
        int version;
        int n = version = json.has("version") ? json.get("version").getAsInt() : 1;
        if (version == 1) {
            return PathModel.migrateFromV1(json);
        }
        String id = json.get("id").getAsString();
        String name = json.has("name") ? json.get("name").getAsString() : id;
        PathModel path = new PathModel(id, name);
        if (json.has("loop")) {
            path.setLoop(json.get("loop").getAsBoolean());
        }
        if (json.has("defaults")) {
            JsonObject defaults = json.getAsJsonObject("defaults");
            if (defaults.has("interp")) {
                path.defaults.interpolationType = InterpolationType.fromString(defaults.get("interp").getAsString());
            }
            if (defaults.has("ease")) {
                path.defaults.easingType = EasingType.fromString(defaults.get("ease").getAsString());
            }
            if (defaults.has("speedMode")) {
                String speedMode = defaults.get("speedMode").getAsString();
                PathDefaults.SpeedMode speedMode2 = path.defaults.speedMode = speedMode.equals("speed") ? PathDefaults.SpeedMode.SPEED : PathDefaults.SpeedMode.DURATION;
            }
            if (defaults.has("banking")) {
                path.defaults.banking = defaults.get("banking").getAsBoolean();
            }
            if (defaults.has("bankingStrength")) {
                path.defaults.bankingStrength = defaults.get("bankingStrength").getAsFloat();
            }
            if (defaults.has("rollMix")) {
                path.defaults.rollMix = defaults.get("rollMix").getAsFloat();
            }
        }
        if (json.has("speed")) {
            JsonObject speed = json.getAsJsonObject("speed");
            if (speed.has("durationSec")) {
                path.speed.durationSec = speed.get("durationSec").getAsFloat();
            }
            if (speed.has("blocksPerSec")) {
                path.speed.blocksPerSec = Float.valueOf(speed.get("blocksPerSec").getAsFloat());
            }
        }
        if (json.has("segments")) {
            JsonArray segments = json.getAsJsonArray("segments");
            for (int i = 0; i < segments.size(); ++i) {
                Segment segment = PathModel.segmentFromJson(segments.get(i).getAsJsonObject());
                path.addSegment(segment);
            }
        }
        if (json.has("lastModified")) {
            path.lastModified = json.get("lastModified").getAsLong();
        }
        if (json.has("lastModifier")) {
            path.lastModifier = UUID.fromString(json.get("lastModifier").getAsString());
        }
        return path;
    }

    private static Segment segmentFromJson(JsonObject json) {
        JsonArray posArray = json.getAsJsonArray("p");
        Vector3f position = new Vector3f(posArray.get(0).getAsFloat(), posArray.get(1).getAsFloat(), posArray.get(2).getAsFloat());
        Quaternionf orientation = new Quaternionf();
        if (json.has("rot")) {
            JsonObject rot = json.getAsJsonObject("rot");
            if (rot.has("q")) {
                JsonArray quat = rot.getAsJsonArray("q");
                orientation.set(quat.get(0).getAsFloat(), quat.get(1).getAsFloat(), quat.get(2).getAsFloat(), quat.get(3).getAsFloat());
            } else {
                float yaw = rot.has("yaw") ? rot.get("yaw").getAsFloat() : 0.0f;
                float pitch = rot.has("pitch") ? rot.get("pitch").getAsFloat() : 0.0f;
                float roll = rot.has("roll") ? rot.get("roll").getAsFloat() : 0.0f;
                orientation.rotateYXZ((float)Math.toRadians(yaw), (float)Math.toRadians(pitch), (float)Math.toRadians(roll));
            }
        }
        Segment segment = new Segment(position, orientation);
        if (json.has("roll")) {
            segment.roll = json.get("roll").getAsFloat();
        }
        if (json.has("fov")) {
            segment.fov = json.get("fov").getAsFloat();
        }
        if (json.has("durationSec")) {
            segment.durationSec = Float.valueOf(json.get("durationSec").getAsFloat());
        }
        if (json.has("weight")) {
            segment.weight = Float.valueOf(json.get("weight").getAsFloat());
        }
        if (json.has("interp")) {
            segment.interpolationType = InterpolationType.fromString(json.get("interp").getAsString());
        }
        if (json.has("ease")) {
            segment.easingType = EasingType.fromString(json.get("ease").getAsString());
        }
        if (json.has("lookAt")) {
            JsonObject lookAt = json.getAsJsonObject("lookAt");
            FollowTarget target = new FollowTarget();
            if (lookAt.has("type")) {
                String type = lookAt.get("type").getAsString().toUpperCase();
                target.type = FollowTarget.FollowType.valueOf(type);
            }
            if (lookAt.has("id")) {
                target.entityId = UUID.fromString(lookAt.get("id").getAsString());
            }
            if (lookAt.has("pos")) {
                JsonArray pos = lookAt.getAsJsonArray("pos");
                target.position = new Vector3f(pos.get(0).getAsFloat(), pos.get(1).getAsFloat(), pos.get(2).getAsFloat());
            }
            if (lookAt.has("followSpeed")) {
                target.followSpeed = lookAt.get("followSpeed").getAsFloat();
            }
            segment.followTarget = target;
        }
        if (json.has("tcb")) {
            JsonObject tcb = json.getAsJsonObject("tcb");
            if (tcb.has("t")) {
                segment.tension = tcb.get("t").getAsFloat();
            }
            if (tcb.has("c")) {
                segment.continuity = tcb.get("c").getAsFloat();
            }
            if (tcb.has("b")) {
                segment.bias = tcb.get("b").getAsFloat();
            }
        }
        if (json.has("bezier")) {
            JsonObject bezier = json.getAsJsonObject("bezier");
            if (bezier.has("in")) {
                JsonArray inArray = bezier.getAsJsonArray("in");
                segment.bezierIn = new Vector3f(inArray.get(0).getAsFloat(), inArray.get(1).getAsFloat(), inArray.get(2).getAsFloat());
            }
            if (bezier.has("out")) {
                JsonArray outArray = bezier.getAsJsonArray("out");
                segment.bezierOut = new Vector3f(outArray.get(0).getAsFloat(), outArray.get(1).getAsFloat(), outArray.get(2).getAsFloat());
            }
        }
        return segment;
    }

    private static PathModel migrateFromV1(JsonObject json) {
        String id = json.get("id").getAsString();
        PathModel path = new PathModel(id, id);
        if (json.has("loop")) {
            path.setLoop(json.get("loop").getAsBoolean());
        }
        if (json.has("speed")) {
            float speed = json.get("speed").getAsFloat();
            path.getSpeed().setDurationMode(10.0f / speed);
        }
        if (json.has("keyframes")) {
            JsonArray keyframes = json.getAsJsonArray("keyframes");
            for (int i = 0; i < keyframes.size(); ++i) {
                JsonObject kf = keyframes.get(i).getAsJsonObject();
                JsonObject pos = kf.getAsJsonObject("pos");
                Vector3f position = new Vector3f((float)pos.get("x").getAsDouble(), (float)pos.get("y").getAsDouble(), (float)pos.get("z").getAsDouble());
                float yaw = 0.0f;
                float pitch = 0.0f;
                float roll = 0.0f;
                if (kf.has("rot")) {
                    JsonObject rot = kf.getAsJsonObject("rot");
                    yaw = rot.has("yaw") ? rot.get("yaw").getAsFloat() : 0.0f;
                    pitch = rot.has("pitch") ? rot.get("pitch").getAsFloat() : 0.0f;
                    roll = rot.has("roll") ? rot.get("roll").getAsFloat() : 0.0f;
                }
                Segment segment = new Segment(position, yaw, pitch, roll);
                if (kf.has("fov")) {
                    segment.fov = kf.get("fov").getAsFloat();
                }
                if (kf.has("lookAt")) {
                    JsonObject lookAt = kf.getAsJsonObject("lookAt");
                    FollowTarget target = new FollowTarget();
                    target.type = FollowTarget.FollowType.BLOCK;
                    target.position = new Vector3f((float)lookAt.get("x").getAsDouble(), (float)lookAt.get("y").getAsDouble(), (float)lookAt.get("z").getAsDouble());
                    segment.followTarget = target;
                }
                path.addSegment(segment);
            }
        }
        path.getDefaults().interpolationType = InterpolationType.CATMULL_CENTRIPETAL;
        path.getDefaults().easingType = EasingType.CUBIC_IN_OUT;
        return path;
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("id", this.id);
        nbt.m_128359_("name", this.name);
        nbt.m_128405_("version", this.version);
        nbt.m_128379_("loop", this.loop);
        nbt.m_128359_("jsonData", this.toJson(new Gson()).toString());
        nbt.m_128356_("lastModified", this.lastModified);
        nbt.m_128359_("lastModifier", this.lastModifier.toString());
        return nbt;
    }

    public static PathModel fromNBT(CompoundTag nbt) {
        if (nbt.m_128441_("jsonData")) {
            String jsonData = nbt.m_128461_("jsonData");
            JsonObject json = (JsonObject)new Gson().fromJson(jsonData, JsonObject.class);
            return PathModel.fromJson(json, new Gson());
        }
        String id = nbt.m_128461_("id");
        String name = nbt.m_128441_("name") ? nbt.m_128461_("name") : id;
        PathModel path = new PathModel(id, name);
        if (nbt.m_128441_("loop")) {
            path.setLoop(nbt.m_128471_("loop"));
        }
        if (nbt.m_128441_("lastModified")) {
            path.lastModified = nbt.m_128454_("lastModified");
        }
        if (nbt.m_128441_("lastModifier")) {
            path.lastModifier = UUID.fromString(nbt.m_128461_("lastModifier"));
        }
        return path;
    }

    public static class PathDefaults {
        public InterpolationType interpolationType = InterpolationType.CATMULL_CENTRIPETAL;
        public EasingType easingType = EasingType.CUBIC_IN_OUT;
        public SpeedMode speedMode = SpeedMode.DURATION;
        public boolean banking = false;
        public float bankingStrength = 1.0f;
        public float rollMix = 0.5f;

        public static enum SpeedMode {
            DURATION,
            SPEED;

        }
    }

    public static class SpeedSettings {
        public float durationSec = 10.0f;
        @Nullable
        public Float blocksPerSec = null;

        public boolean isSpeedMode() {
            return this.blocksPerSec != null;
        }

        public void setDurationMode(float duration) {
            this.durationSec = duration;
            this.blocksPerSec = null;
        }

        public void setSpeedMode(float blocksPerSec) {
            this.blocksPerSec = Float.valueOf(blocksPerSec);
        }
    }

    public static class Segment {
        public Vector3f position;
        public Quaternionf orientation;
        public float roll = 0.0f;
        public float fov = 90.0f;
        @Nullable
        public Float durationSec = null;
        @Nullable
        public Float weight = null;
        @Nullable
        public InterpolationType interpolationType = null;
        @Nullable
        public EasingType easingType = null;
        @Nullable
        public FollowTarget followTarget = null;
        public float tension = 0.0f;
        public float continuity = 0.0f;
        public float bias = 0.0f;
        @Nullable
        public Vector3f bezierIn = null;
        @Nullable
        public Vector3f bezierOut = null;

        public Segment(Vector3f position, Quaternionf orientation) {
            this.position = new Vector3f((Vector3fc)position);
            this.orientation = new Quaternionf((Quaternionfc)orientation);
        }

        public Segment(Vector3f position, float yaw, float pitch, float roll) {
            this.position = new Vector3f((Vector3fc)position);
            this.orientation = new Quaternionf().rotateYXZ((float)Math.toRadians(yaw), (float)Math.toRadians(pitch), 0.0f);
            this.roll = roll;
        }

        public Vector3f toEulerDegrees() {
            Vector3f euler = new Vector3f();
            this.orientation.getEulerAnglesYXZ(euler);
            return euler.mul(57.29578f);
        }
    }

    public static class ArcLengthLUT {
        private final float[] parameters;
        private final float[] arcLengths;
        private final float totalLength;

        public ArcLengthLUT(float[] parameters, float[] arcLengths, float totalLength) {
            this.parameters = parameters;
            this.arcLengths = arcLengths;
            this.totalLength = totalLength;
        }

        public static ArcLengthLUT empty() {
            return new ArcLengthLUT(new float[]{0.0f, 1.0f}, new float[]{0.0f, 0.0f}, 0.0f);
        }

        public float arcLengthToParameter(float s) {
            if (s <= 0.0f) {
                return 0.0f;
            }
            if (s >= this.totalLength) {
                return 1.0f;
            }
            int index = this.binarySearchArcLength(s);
            if (index < 0) {
                index = 0;
            }
            if (index >= this.arcLengths.length - 1) {
                return 1.0f;
            }
            float s1 = this.arcLengths[index];
            float s2 = this.arcLengths[index + 1];
            float t1 = this.parameters[index];
            float t2 = this.parameters[index + 1];
            float alpha = (s - s1) / (s2 - s1);
            return t1 + alpha * (t2 - t1);
        }

        public float parameterToArcLength(float t) {
            if (t <= 0.0f) {
                return 0.0f;
            }
            if (t >= 1.0f) {
                return this.totalLength;
            }
            int index = this.binarySearchParameter(t);
            if (index < 0) {
                index = 0;
            }
            if (index >= this.parameters.length - 1) {
                return this.totalLength;
            }
            float t1 = this.parameters[index];
            float t2 = this.parameters[index + 1];
            float s1 = this.arcLengths[index];
            float s2 = this.arcLengths[index + 1];
            float alpha = (t - t1) / (t2 - t1);
            return s1 + alpha * (s2 - s1);
        }

        private int binarySearchArcLength(float s) {
            int low = 0;
            int high = this.arcLengths.length - 1;
            while (low <= high) {
                int mid = (low + high) / 2;
                if (this.arcLengths[mid] < s) {
                    low = mid + 1;
                    continue;
                }
                if (this.arcLengths[mid] > s) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return high;
        }

        private int binarySearchParameter(float t) {
            int low = 0;
            int high = this.parameters.length - 1;
            while (low <= high) {
                int mid = (low + high) / 2;
                if (this.parameters[mid] < t) {
                    low = mid + 1;
                    continue;
                }
                if (this.parameters[mid] > t) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return high;
        }

        public float getTotalLength() {
            return this.totalLength;
        }
    }

    public static class FollowTarget {
        public FollowType type = FollowType.NONE;
        @Nullable
        public UUID entityId = null;
        @Nullable
        public Vector3f position = null;
        public float followSpeed = 1.0f;

        public static enum FollowType {
            NONE,
            SELF,
            ENTITY,
            BLOCK;

        }
    }
}

