/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.path.interpolation;

public enum EasingType {
    LINEAR("linear"),
    QUAD_IN("quadIn"),
    QUAD_OUT("quadOut"),
    QUAD_IN_OUT("quadInOut"),
    CUBIC_IN("cubicIn"),
    CUBIC_OUT("cubicOut"),
    CUBIC_IN_OUT("cubicInOut"),
    QUART_IN("quartIn"),
    QUART_OUT("quartOut"),
    QUART_IN_OUT("quartInOut"),
    QUINT_IN("quintIn"),
    QUINT_OUT("quintOut"),
    QUINT_IN_OUT("quintInOut"),
    SINE_IN("sineIn"),
    SINE_OUT("sineOut"),
    SINE_IN_OUT("sineInOut"),
    EXPO_IN("expoIn"),
    EXPO_OUT("expoOut"),
    EXPO_IN_OUT("expoInOut"),
    CIRC_IN("circIn"),
    CIRC_OUT("circOut"),
    CIRC_IN_OUT("circInOut"),
    BACK_IN("backIn"),
    BACK_OUT("backOut"),
    BACK_IN_OUT("backInOut"),
    ELASTIC_IN("elasticIn"),
    ELASTIC_OUT("elasticOut"),
    ELASTIC_IN_OUT("elasticInOut"),
    BOUNCE_IN("bounceIn"),
    BOUNCE_OUT("bounceOut"),
    BOUNCE_IN_OUT("bounceInOut");

    private final String name;

    private EasingType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public float apply(float t) {
        t = Math.max(0.0f, Math.min(1.0f, t));
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case LINEAR -> t;
            case QUAD_IN -> t * t;
            case QUAD_OUT -> 1.0f - (1.0f - t) * (1.0f - t);
            case QUAD_IN_OUT -> {
                if (t < 0.5f) {
                    yield 2.0f * t * t;
                }
                yield 1.0f - 2.0f * (1.0f - t) * (1.0f - t);
            }
            case CUBIC_IN -> t * t * t;
            case CUBIC_OUT -> 1.0f - (float)Math.pow(1.0f - t, 3.0);
            case CUBIC_IN_OUT -> {
                if (t < 0.5f) {
                    yield 4.0f * t * t * t;
                }
                yield 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 3.0) / 2.0f;
            }
            case QUART_IN -> t * t * t * t;
            case QUART_OUT -> 1.0f - (float)Math.pow(1.0f - t, 4.0);
            case QUART_IN_OUT -> {
                if (t < 0.5f) {
                    yield 8.0f * t * t * t * t;
                }
                yield 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 4.0) / 2.0f;
            }
            case QUINT_IN -> t * t * t * t * t;
            case QUINT_OUT -> 1.0f - (float)Math.pow(1.0f - t, 5.0);
            case QUINT_IN_OUT -> {
                if (t < 0.5f) {
                    yield 16.0f * t * t * t * t * t;
                }
                yield 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 5.0) / 2.0f;
            }
            case SINE_IN -> 1.0f - (float)Math.cos((double)t * Math.PI / 2.0);
            case SINE_OUT -> (float)Math.sin((double)t * Math.PI / 2.0);
            case SINE_IN_OUT -> -((float)(Math.cos(Math.PI * (double)t) - 1.0)) / 2.0f;
            case EXPO_IN -> {
                if (t == 0.0f) {
                    yield 0.0f;
                }
                yield (float)Math.pow(2.0, 10.0f * (t - 1.0f));
            }
            case EXPO_OUT -> {
                if (t == 1.0f) {
                    yield 1.0f;
                }
                yield 1.0f - (float)Math.pow(2.0, -10.0f * t);
            }
            case EXPO_IN_OUT -> {
                if (t == 0.0f) {
                    yield 0.0f;
                }
                if (t == 1.0f) {
                    yield 1.0f;
                }
                if (t < 0.5f) {
                    yield (float)Math.pow(2.0, 20.0f * t - 10.0f) / 2.0f;
                }
                yield (2.0f - (float)Math.pow(2.0, -20.0f * t + 10.0f)) / 2.0f;
            }
            case CIRC_IN -> 1.0f - (float)Math.sqrt(1.0f - t * t);
            case CIRC_OUT -> (float)Math.sqrt(1.0f - (t - 1.0f) * (t - 1.0f));
            case CIRC_IN_OUT -> {
                if (t < 0.5f) {
                    yield (1.0f - (float)Math.sqrt(1.0f - 4.0f * t * t)) / 2.0f;
                }
                yield ((float)Math.sqrt(1.0f - (-2.0f * t + 2.0f) * (-2.0f * t + 2.0f)) + 1.0f) / 2.0f;
            }
            case BACK_IN -> {
                float c1 = 1.70158f;
                float c3 = c1 + 1.0f;
                yield c3 * t * t * t - c1 * t * t;
            }
            case BACK_OUT -> {
                float c1 = 1.70158f;
                float c3 = c1 + 1.0f;
                yield 1.0f + c3 * (float)Math.pow(t - 1.0f, 3.0) + c1 * (float)Math.pow(t - 1.0f, 2.0);
            }
            case BACK_IN_OUT -> {
                float c1 = 1.70158f;
                float c2 = c1 * 1.525f;
                if (t < 0.5f) {
                    yield (float)Math.pow(2.0f * t, 2.0) * ((c2 + 1.0f) * 2.0f * t - c2) / 2.0f;
                }
                yield ((float)Math.pow(2.0f * t - 2.0f, 2.0) * ((c2 + 1.0f) * (t * 2.0f - 2.0f) + c2) + 2.0f) / 2.0f;
            }
            case ELASTIC_IN -> {
                if (t == 0.0f) {
                    yield 0.0f;
                }
                if (t == 1.0f) {
                    yield 1.0f;
                }
                float c4 = 2.0943952f;
                yield -((float)(Math.pow(2.0, 10.0f * (t - 1.0f)) * Math.sin((t - 1.0f) * c4)));
            }
            case ELASTIC_OUT -> {
                if (t == 0.0f) {
                    yield 0.0f;
                }
                if (t == 1.0f) {
                    yield 1.0f;
                }
                float c4 = 2.0943952f;
                yield (float)(Math.pow(2.0, -10.0f * t) * Math.sin(t * c4)) + 1.0f;
            }
            case ELASTIC_IN_OUT -> {
                if (t == 0.0f) {
                    yield 0.0f;
                }
                if (t == 1.0f) {
                    yield 1.0f;
                }
                float c5 = 1.3962634f;
                if (t < 0.5f) {
                    yield -((float)(Math.pow(2.0, 20.0f * t - 10.0f) * Math.sin((20.0f * t - 11.125f) * c5))) / 2.0f;
                }
                yield (float)(Math.pow(2.0, -20.0f * t + 10.0f) * Math.sin((20.0f * t - 11.125f) * c5)) / 2.0f + 1.0f;
            }
            case BOUNCE_IN -> 1.0f - EasingType.bounceOut(1.0f - t);
            case BOUNCE_OUT -> EasingType.bounceOut(t);
            case BOUNCE_IN_OUT -> t < 0.5f ? (1.0f - EasingType.bounceOut(1.0f - 2.0f * t)) / 2.0f : (1.0f + EasingType.bounceOut(2.0f * t - 1.0f)) / 2.0f;
        };
    }

    private static float bounceOut(float t) {
        float n1 = 7.5625f;
        float d1 = 2.75f;
        if (t < 1.0f / d1) {
            return n1 * t * t;
        }
        if (t < 2.0f / d1) {
            return n1 * (t -= 1.5f / d1) * t + 0.75f;
        }
        if (t < 2.5f / d1) {
            return n1 * (t -= 2.25f / d1) * t + 0.9375f;
        }
        return n1 * (t -= 2.625f / d1) * t + 0.984375f;
    }

    public static EasingType fromString(String str) {
        if (str == null) {
            return CUBIC_IN_OUT;
        }
        String lower = str.toLowerCase().trim();
        for (EasingType type : EasingType.values()) {
            if (!type.name.toLowerCase().equals(lower)) continue;
            return type;
        }
        return switch (lower) {
            case "ease" -> CUBIC_IN_OUT;
            case "easein" -> CUBIC_IN;
            case "easeout" -> CUBIC_OUT;
            case "easeinout" -> CUBIC_IN_OUT;
            case "quad" -> QUAD_IN_OUT;
            case "cubic" -> CUBIC_IN_OUT;
            case "sine" -> SINE_IN_OUT;
            default -> CUBIC_IN_OUT;
        };
    }

    public String toString() {
        return this.name;
    }
}

