/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.path.interpolation;

public enum InterpolationType {
    LINEAR("linear"),
    COSINE("cosine"),
    HERMITE("hermite"),
    BEZIER("bezier"),
    CATMULL_UNIFORM("catmull:uniform"),
    CATMULL_CENTRIPETAL("catmull:centripetal"),
    CATMULL_CHORDAL("catmull:chordal");

    private final String name;

    private InterpolationType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public float getCatmullAlpha() {
        return switch (this) {
            case CATMULL_UNIFORM -> 0.0f;
            case CATMULL_CENTRIPETAL -> 0.5f;
            case CATMULL_CHORDAL -> 1.0f;
            default -> 0.5f;
        };
    }

    public boolean isCatmullRom() {
        return this == CATMULL_UNIFORM || this == CATMULL_CENTRIPETAL || this == CATMULL_CHORDAL;
    }

    public static InterpolationType fromString(String str) {
        if (str == null) {
            return CATMULL_CENTRIPETAL;
        }
        String lower = str.toLowerCase().trim();
        for (InterpolationType type : InterpolationType.values()) {
            if (!type.name.equals(lower)) continue;
            return type;
        }
        return switch (lower) {
            case "smooth" -> CATMULL_CENTRIPETAL;
            case "step" -> LINEAR;
            case "catmull", "catmullrom" -> CATMULL_CENTRIPETAL;
            default -> CATMULL_CENTRIPETAL;
        };
    }

    public String toString() {
        return this.name;
    }
}

