/*
 * Decompiled with CFR 0.152.
 */
package net.trollblox.superrecipes.config;

import com.mojang.datafixers.util.Pair;
import net.trollblox.superrecipes.SuperRecipes;
import net.trollblox.superrecipes.config.SimpleConfig;
import net.trollblox.superrecipes.config.SuperConfigProvider;

public class SuperConfigs {
    public static SimpleConfig CONFIG;
    private static SuperConfigProvider configs;
    public static int HOPPER_TICK_DELAY;
    public static float ANCIENT_DEBRIS_DROP_RATE;
    public static String HOPPER_TOGGLE_ITEM;
    public static boolean CHANNELING_AFFECTS_WEATHER;

    public static void registerConfigs() {
        configs = new SuperConfigProvider();
        SuperConfigs.createConfigs();
        CONFIG = SimpleConfig.of("super-recipes").provider(configs).request();
        SuperConfigs.assignConfigs();
    }

    private static void createConfigs() {
        configs.addKeyValuePair(new Pair((Object)"hopper-tick-delay", (Object)0), "Delay in tick for hopper transfer speed");
        configs.addKeyValuePair(new Pair((Object)"ancient-debris-droprate", (Object)Float.valueOf(0.005f)), "Drop chance for ancient debris from Zombified Piglins");
        configs.addKeyValuePair(new Pair((Object)"hopper-toggle-item", (Object)"wheat_seeds"), "Item held when opening a hopper to toggle speed");
        configs.addKeyValuePair(new Pair((Object)"channeling-affects-weather", (Object)true), "Channeling Tridents start thunderstorms");
    }

    private static void assignConfigs() {
        HOPPER_TICK_DELAY = CONFIG.getOrDefault("hopper-tick-delay", 0);
        SuperRecipes.LOGGER.info("Assigned HOPPER_TICK_DELAY to {}", (Object)HOPPER_TICK_DELAY);
        ANCIENT_DEBRIS_DROP_RATE = (float)CONFIG.getOrDefault("ancient-debris-droprate", 0.005f);
        SuperRecipes.LOGGER.info("Assigned ANCIENT_DEBRIS_DROP_RATE to {}", (Object)Float.valueOf(ANCIENT_DEBRIS_DROP_RATE));
        HOPPER_TOGGLE_ITEM = CONFIG.getOrDefault("hopper-toggle-item", "wheat_seeds");
        SuperRecipes.LOGGER.info("Assigned HOPPER_TOGGLE_ITEM to {}", (Object)HOPPER_TOGGLE_ITEM);
        CHANNELING_AFFECTS_WEATHER = CONFIG.getOrDefault("channeling-affects-weather", true);
        SuperRecipes.LOGGER.info("Assigned CHANNELING_AFFECTS_WEATHER to {}", (Object)CHANNELING_AFFECTS_WEATHER);
    }
}

