package net.ramixin.slashlength.client.mixins;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_342;
import net.ramixin.slashlength.TextFieldWidgetDuck;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_342.class)
public abstract class TextFieldWidgetMixin implements TextFieldWidgetDuck {

    @Shadow private int selectionStart;
    @Shadow private int selectionEnd;

    @Unique
    private boolean isChatBox = false;

    @WrapOperation(method = "keyPressed", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/widget/TextFieldWidget;write(Ljava/lang/String;)V", ordinal = 0))
    private void preventTruncationIfPastingCommand(class_342 instance, String text, Operation<Void> original) {
        boolean isCommand = false;
        if(isChatBox) {
            if (Math.min(Math.min(this.selectionStart, this.selectionEnd), instance.method_1881()) > 0) {
                isCommand = instance.method_1882().startsWith("/");
            } else isCommand = text.startsWith("/");
        }
        if (isCommand) instance.method_1880(Integer.MAX_VALUE);
        else instance.method_1880(256);
        original.call(instance, text);
    }

    @Override
    public void slashlength$setAsChatBox() {
        isChatBox = true;
    }
}
