/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightitemcooldown.Command;

import dev.atrox.lightitemcooldown.Command.DiscordCommand;
import dev.atrox.lightitemcooldown.Command.ReloadCommand;
import dev.atrox.lightitemcooldown.CoolDown.CooldownConfig;
import dev.atrox.lightitemcooldown.HexColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;

public class LightItemCoolDownCommand
implements CommandExecutor {
    private final CooldownConfig cooldownConfig;
    private final JavaPlugin plugin;

    public LightItemCoolDownCommand(JavaPlugin plugin, CooldownConfig cooldownConfig) {
        this.plugin = plugin;
        this.cooldownConfig = cooldownConfig;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String usageMessage = this.plugin.getConfig().getString("messages.usage", "#ff1100Usage: #dcadff/lightitemcooldown reload | /lightitemcooldown discord");
        String invalidCommandMessage = this.plugin.getConfig().getString("messages.invalid-command", "&cInvalid command. Usage: /lightitemcooldown reload | /lightitemcooldown discord");
        if (args.length == 0) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', usageMessage));
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                new ReloadCommand(this.cooldownConfig).onCommand(sender, command, label, args);
                break;
            }
            case "discord": {
                new DiscordCommand().execute(sender);
                break;
            }
            default: {
                sender.sendMessage(HexColor.translateAlternateColorCodes('&', invalidCommandMessage));
            }
        }
        return true;
    }
}

