/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightitemcooldown.CoolDown;

import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class CooldownConfig {
    private final JavaPlugin plugin;
    private FileConfiguration config;

    public CooldownConfig(JavaPlugin plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public long getCooldownDuration(String key) {
        return this.config.getLong("cooldown-durations." + key, 0L);
    }

    public boolean isCooldownEnabled(String key) {
        return this.config.getBoolean("enable-cooldowns." + key, true);
    }

    public boolean isSlotCooldownEnabled() {
        return this.config.getBoolean("slot-cooldown");
    }

    public boolean isOpBypassEnabled() {
        return this.config.getBoolean("op-bypass", false);
    }

    public String getReloadMessage() {
        return this.config.getString("reload-message", "&aConfiguration reloaded.");
    }
}

