/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightitemcooldown.CoolDown;

import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class CooldownConfig {
    private final JavaPlugin plugin;
    private FileConfiguration config;

    public CooldownConfig(JavaPlugin plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public long getCooldownDuration(String key) {
        return this.config.getLong("cooldown-durations." + key, 0L);
    }

    public boolean isCooldownEnabled(String key) {
        return this.config.getBoolean("enable-cooldowns." + key, true);
    }

    public boolean isSlotCooldownEnabled() {
        return this.config.getBoolean("slot-cooldown");
    }

    public boolean isOpBypassEnabled() {
        return this.config.getBoolean("op-bypass", false);
    }

    public String getReloadMessage() {
        return this.config.getString("reload-message", "&b\u029f\u026a\u0262\u029c\u1d1b\u026a\u1d1b\u1d07\u1d0d\u1d04\u1d0f\u1d0f\u029f\u1d05\u1d0f\u1d21\u0274\u279c #f5d984Configuration reloaded successfully.");
    }

    public boolean isWorldBlacklistEnabled() {
        return this.config.getBoolean("blacklist-world.enabled", false);
    }

    public List<String> getBlacklistedWorlds() {
        return this.config.getStringList("blacklist-world.worlds");
    }
}

