/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightitemcooldown.CoolDown;

import dev.atrox.lightitemcooldown.CoolDown.CooldownConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerRiptideEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerItemUseListener
implements Listener {
    private final Map<String, Map<UUID, Long>> cooldowns;
    private final CooldownConfig cooldownConfig;

    public PlayerItemUseListener(Map<String, Map<UUID, Long>> cooldowns, CooldownConfig cooldownConfig) {
        this.cooldowns = cooldowns;
        this.cooldownConfig = cooldownConfig;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getItem() == null || event.getItem().getType() != Material.ENDER_PEARL) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (this.checkCooldown(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof EnderPearl)) {
            return;
        }
        if (!(projectile.getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)projectile.getShooter();
        this.handleCooldown(player);
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            return;
        }
        this.handleCooldown(event.getPlayer());
    }

    @EventHandler
    public void onPlayerConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        ItemStack mainHandItem = player.getInventory().getItemInMainHand();
        ItemStack offHandItem = player.getInventory().getItemInOffHand();
        if (!item.isSimilar(mainHandItem) && !(item = offHandItem).isSimilar(offHandItem)) {
            return;
        }
        Material material = item.getType();
        String key = this.getKeyFromMaterial(material, item);
        if (key != null) {
            this.applyCooldown(player, key, material);
        }
    }

    @EventHandler
    public void onEntityShootBow(EntityShootBowEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        ItemStack bow = event.getBow();
        if (bow == null) {
            return;
        }
        ItemStack mainHandItem = player.getInventory().getItemInMainHand();
        ItemStack offHandItem = player.getInventory().getItemInOffHand();
        if (!bow.isSimilar(mainHandItem) && !(bow = offHandItem).isSimilar(offHandItem)) {
            return;
        }
        Material material = bow.getType();
        String key = this.getKeyFromMaterial(material, bow);
        if (key != null) {
            this.applyCooldown(player, key, material);
        }
    }

    @EventHandler
    public void onPlayerRiptide(PlayerRiptideEvent event) {
        Player player = event.getPlayer();
        ItemStack trident = player.getInventory().getItemInMainHand();
        if (trident.getType() != Material.TRIDENT && (trident = player.getInventory().getItemInOffHand()).getType() != Material.TRIDENT) {
            return;
        }
        int riptideLevel = trident.getEnchantmentLevel(Enchantment.RIPTIDE);
        if (riptideLevel > 0) {
            String riptideKey = "riptide_trident";
            this.applyCooldown(player, riptideKey, Material.TRIDENT);
        }
    }

    @EventHandler
    public void onProjectileLaunchTrident(ProjectileLaunchEvent event) {
        Projectile projectile = event.getEntity();
        if (!(projectile.getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)projectile.getShooter();
        if (projectile instanceof Trident) {
            ItemStack tridentItem = player.getInventory().getItemInMainHand();
            if (tridentItem.getType() != Material.TRIDENT && (tridentItem = player.getInventory().getItemInOffHand()).getType() != Material.TRIDENT) {
                return;
            }
            int riptideLevel = tridentItem.getEnchantmentLevel(Enchantment.RIPTIDE);
            if (riptideLevel > 0) {
                String riptideKey = "riptide_trident";
                this.applyCooldown(player, riptideKey, Material.TRIDENT);
            } else {
                String normalTridentKey = "trident";
                this.applyCooldown(player, normalTridentKey, Material.TRIDENT);
            }
        }
    }

    private void handleCooldown(Player player) {
        if (this.shouldBypass(player)) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long cooldownTime = this.cooldownConfig.getCooldownDuration("ender_pearl") * 1000L;
        Map itemCooldowns = this.cooldowns.computeIfAbsent("ender_pearl", k -> new HashMap());
        itemCooldowns.put(player.getUniqueId(), currentTime + cooldownTime);
        this.cooldowns.put("ender_pearl", itemCooldowns);
        if (this.cooldownConfig.isSlotCooldownEnabled()) {
            player.setCooldown(Material.ENDER_PEARL, (int)(this.cooldownConfig.getCooldownDuration("ender_pearl") * 20L));
        }
    }

    private boolean checkCooldown(Player player) {
        if (this.shouldBypass(player)) {
            return false;
        }
        Map<UUID, Long> itemCooldowns = this.cooldowns.get("ender_pearl");
        if (itemCooldowns == null) {
            return false;
        }
        Long cooldownEnd = itemCooldowns.get(player.getUniqueId());
        if (cooldownEnd == null) {
            return false;
        }
        return cooldownEnd > System.currentTimeMillis();
    }

    private boolean shouldBypass(Player player) {
        return !this.cooldownConfig.isCooldownEnabled("ender_pearl") || player.hasPermission("lightitemcooldown.bypass") || player.isOp() && this.cooldownConfig.isOpBypassEnabled();
    }

    private void applyCooldown(Player player, String key, Material material) {
        long timeLeft;
        if (!this.cooldownConfig.isCooldownEnabled(key)) {
            return;
        }
        if (player.hasPermission("lightitemcooldown.bypass") || player.isOp() && this.cooldownConfig.isOpBypassEnabled()) {
            return;
        }
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        long cooldownTime = this.cooldownConfig.getCooldownDuration(key) * 1000L;
        Map itemCooldowns = this.cooldowns.computeIfAbsent(key, k -> new HashMap());
        if (itemCooldowns.containsKey(playerId) && (timeLeft = (Long)itemCooldowns.get(playerId) - currentTime) > 0L) {
            return;
        }
        itemCooldowns.put(playerId, currentTime + cooldownTime);
        if (this.cooldownConfig.isSlotCooldownEnabled()) {
            player.setCooldown(material, (int)(cooldownTime / 50L));
        }
        this.cooldowns.put(key, itemCooldowns);
    }

    private String getKeyFromMaterial(Material material, ItemStack item) {
        switch (material) {
            case SHIELD: {
                return "shield";
            }
            case BOW: {
                return "bow";
            }
            case CROSSBOW: {
                return "crossbow";
            }
            case TRIDENT: {
                int riptideLevel = item.getEnchantmentLevel(Enchantment.RIPTIDE);
                if (riptideLevel > 0) {
                    return "riptide_trident";
                }
                return "trident";
            }
            case GOLDEN_APPLE: {
                return "golden_apple";
            }
            case ENCHANTED_GOLDEN_APPLE: {
                return "enchanted_golden_apple";
            }
        }
        return null;
    }
}

