/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.mods.exitconfirmation.config;

import com.ultreon.mods.exitconfirmation.OrderedHashMap;
import com.ultreon.mods.exitconfirmation.config.ConfigEntry;
import com.ultreon.mods.exitconfirmation.config.entries.BooleanEntry;
import com.ultreon.mods.exitconfirmation.config.entries.DoubleEntry;
import com.ultreon.mods.exitconfirmation.config.entries.FloatEntry;
import com.ultreon.mods.exitconfirmation.config.entries.IntEntry;
import com.ultreon.mods.exitconfirmation.config.entries.LongEntry;
import com.ultreon.mods.exitconfirmation.config.entries.StringEntry;
import com.ultreon.mods.exitconfirmation.config.entries.UUIDEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.UUID;

public class Config {
    public static final File FILE = new File("./config/exit-confirmation.txt");
    private static final OrderedHashMap<String, ConfigEntry<?>> ENTRIES = new OrderedHashMap();
    public final ConfigEntry<Boolean> closePrompt = this.add("prompt.enable", true, "Show close prompt.");
    public final ConfigEntry<Boolean> closePromptInGame = this.add("prompt.inGame", true, "Show the close prompt when in-game.");
    public final ConfigEntry<Boolean> closePromptQuitButton = this.add("prompt.quitButton", true, "Show the close prompt when clicking the quit button.");
    public final ConfigEntry<Boolean> quitOnEscInTitle = this.add("prompt.escInTitle", true, "Show the close prompt when pressing escape in the title screen.");
    public final ConfigEntry<Integer> confirmDelay = this.add("screen.confirmDelay", 40, 5, 100, "Confirmation delay in ticks.");

    private ConfigEntry<Boolean> add(String key, boolean defaultValue, String comment) {
        ConfigEntry<Boolean> entry = new BooleanEntry(key, defaultValue).comment(comment);
        ENTRIES.put(key, entry);
        return entry;
    }

    private ConfigEntry<Integer> add(String key, int defaultValue, int min, int max, String comment) {
        ConfigEntry<Integer> entry = new IntEntry(key, defaultValue, min, max).comment(comment);
        ENTRIES.put(key, entry);
        return entry;
    }

    private ConfigEntry<Long> add(String key, long defaultValue, long min, long max, String comment) {
        ConfigEntry<Long> entry = new LongEntry(key, defaultValue, min, max).comment(comment);
        ENTRIES.put(key, entry);
        return entry;
    }

    private ConfigEntry<Float> add(String key, float defaultValue, float min, float max, String comment) {
        ConfigEntry<Float> entry = new FloatEntry(key, defaultValue, min, max).comment(comment);
        ENTRIES.put(key, entry);
        return entry;
    }

    private ConfigEntry<Double> add(String key, double defaultValue, double min, double max, String comment) {
        ConfigEntry<Double> entry = new DoubleEntry(key, defaultValue, min, max).comment(comment);
        ENTRIES.put(key, entry);
        return entry;
    }

    private ConfigEntry<String> add(String key, String defaultValue, String comment) {
        ConfigEntry<String> entry = new StringEntry(key, defaultValue).comment(comment);
        ENTRIES.put(key, entry);
        return entry;
    }

    private ConfigEntry<UUID> add(String key, UUID defaultValue, String comment) {
        ConfigEntry<UUID> entry = new UUIDEntry(key, defaultValue).comment(comment);
        ENTRIES.put(key, entry);
        return entry;
    }

    public static void load() {
        try (BufferedReader reader2 = new BufferedReader(new FileReader(FILE));){
            String s;
            while ((s = reader2.readLine()) != null) {
                String[] entryArr;
                if (s.startsWith("#") || (entryArr = s.split("=", 2)).length <= 1) continue;
                ConfigEntry<?> entry = ENTRIES.get(entryArr[0]);
                entry.readAndSet(entryArr[1]);
            }
        }
        catch (FileNotFoundException reader2) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try (BufferedWriter writer2 = new BufferedWriter(new FileWriter(FILE));){
            for (ConfigEntry<?> e : ENTRIES.values()) {
                String key = e.getKey();
                String value = e.write();
                String comment = e.getComment();
                if (comment != null && !comment.isEmpty()) {
                    writer2.write("# ");
                    writer2.write(comment.trim().replaceAll("\r\n", " ").replaceAll("\r", " ").replaceAll("\n", " "));
                    writer2.newLine();
                }
                writer2.write(key);
                writer2.write("=");
                writer2.write(value);
                writer2.newLine();
            }
        }
        catch (FileNotFoundException writer2) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ConfigEntry<?>[] values() {
        return ENTRIES.values().toArray(new ConfigEntry[0]);
    }
}

