package com.ultreon.mods.exitconfirmation;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1664;
import net.minecraft.class_356;
import net.minecraft.class_388;

@SuppressWarnings({"FieldMayBeFinal", "FieldCanBeLocal"})
@Environment(EnvType.CLIENT)
public class ConfirmExitScreen extends class_388 {
    private final String description = "Are you sure you want to exit Minecraft?";
    private final String title = "Exit Confirmation";
    private class_388 previousScreen;
    private int ticksUntilEnableIn;
    private class_356 yesButton;

    public ConfirmExitScreen(class_388 previousScreen) {
        super();
    }

    @Override
    public void method_1044() {
        super.method_1044();

        this.field_1232.clear();

        this.field_1232.add(yesButton = new class_356(0, this.field_1230 / 2 - 105, this.field_1231 / 6 + 96, 100, 20, class_1664.method_5934("gui.yes")));
        this.field_1232.add(new class_356(1, this.field_1230 / 2 + 5, this.field_1231 / 6 + 96, 100, 20, class_1664.method_5934("gui.no")));

        yesButton.field_1055 = false;

        this.setButtonDelay(10);
    }

    @Override
    protected void method_1027(class_356 button) {
        if (button.field_1054 == 0) {
            if (this.field_1229 != null) {
                button.field_1055 = false;
                ExitConfirmation.allowExit = true;
                if (this.field_1229.field_3803 != null && this.field_1229.method_2907()) {
                    WorldUtils.saveWorldThenQuitGame();
                    return;
                }

                this.field_1229.method_2949();
            }
        } else if (button.field_1054 == 1) {
            if (this.field_1229 != null) {
                button.field_1055 = false;
                this.field_1229.method_2928(this.previousScreen);
            }
        }
    }

    @Override
    public void method_1025(int mouseX, int mouseY, float partialTicks) {
        this.method_1043();

        this.method_990(this.field_1234, this.title, this.field_1230 / 2, 70, 0xffffff);
        this.method_990(this.field_1234, this.description, this.field_1230 / 2, 90, 0xbfbfbf);

        super.method_1025(mouseX, mouseY, partialTicks);

    }

    /**
     * Sets the number of ticks to wait before enabling the buttons.
     */
    public void setButtonDelay(int ticksUntilEnable) {
        this.ticksUntilEnableIn = ticksUntilEnable;
    }

    @Override
    public void method_1033() {
        if (this.ticksUntilEnableIn-- <= 0) {
            yesButton.field_1055 = true;
        }
    }

    public void back() {
        this.field_1229.method_2928(this.previousScreen);
    }

    @Override
    protected void method_1024(char id, int code) {
        // Don't allow closing the GUI
    }
}
