package com.ultreon.mods.exitconfirmation;

import com.ultreon.mods.exitconfirmation.config.Config;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_1600;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExitConfirmation implements ClientModInitializer {

    public static final String MOD_ID = "exit_confirm";
    public static boolean allowExit;
    public static final Config CONFIG = new Config();

    // Directly reference a log4j logger.
    @SuppressWarnings("unused")
    static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void onInitializeClient() {
        Config.load();
        Config.save();

        WindowCloseEvent.EVENT.register(this::onWindowClose);
    }

    public ActionResult onWindowClose(WindowCloseEvent.Source source) {
        class_1600 mc = class_1600.method_2965();

        // Check close source.
        if (source == WindowCloseEvent.Source.GENERIC) {
            // Always cancel if the world isn't loaded but also being ingame. (Fixes bug)
            if (mc.field_3803 == null && mc.field_3816 == null) {
                return ActionResult.CANCEL;
            }

            // Otherwise only cancel when the close prompt is enabled.
            if (ExitConfirmation.CONFIG.closePrompt.get()) {
                // Allow closing ingame if enabled in config.
                if (mc.field_3803 != null && !ExitConfirmation.CONFIG.closePromptInGame.get()) {
                    return ActionResult.PASS;
                }

                // Only show screen, when the screen isn't the confirmation screen yet.
                if (!(mc.field_3816 instanceof ConfirmExitScreen)) {
                    // Set the screen.
                    mc.method_2928(new ConfirmExitScreen(mc.field_3816));
                }

                // Cancel the event.
                return ActionResult.CANCEL;
            }
        } else if (source == WindowCloseEvent.Source.QUIT_BUTTON) {
            // Cancel quit button when set in config, and the screen isn't currently the confirmation screen already.
            if (ExitConfirmation.CONFIG.closePrompt.get() && ExitConfirmation.CONFIG.closePromptQuitButton.get() && !(mc.field_3816 instanceof ConfirmExitScreen)) {
                mc.method_2928(new ConfirmExitScreen(mc.field_3816));
                return ActionResult.CANCEL;
            }
        }
        return ActionResult.PASS;
    }
}
