package com.ultreon.mods.exitconfirmation.mixin;

import com.ultreon.mods.exitconfirmation.ActionResult;
import com.ultreon.mods.exitconfirmation.ConfirmExitScreen;
import com.ultreon.mods.exitconfirmation.ExitConfirmation;
import com.ultreon.mods.exitconfirmation.WindowCloseEvent;
import net.minecraft.class_356;
import net.minecraft.class_388;
import net.minecraft.class_624;
import org.lwjgl.input.Keyboard;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_624.class)
public abstract class TitleScreenMixin extends class_388 {
    @Inject(method = "buttonClicked", at = @At("HEAD"), cancellable = true)
    public void exitConfirm$injectButtonClick(class_356 button, CallbackInfo ci) {
        if (button.field_1054 == 4) {
            if (WindowCloseEvent.EVENT.invoker().closing(WindowCloseEvent.Source.QUIT_BUTTON) == ActionResult.CANCEL) {
                ci.cancel();
                return;
            }
            ExitConfirmation.allowExit = true;
            field_1229.method_2949();
        }
    }

    @Inject(method = "keyPressed", at = @At("HEAD"), cancellable = true)
    public void exitConfirm$injectEscapePrompt(char id, int code, CallbackInfo ci) {
        if (code == Keyboard.KEY_ESCAPE && ExitConfirmation.CONFIG.closePrompt.get() && ExitConfirmation.CONFIG.quitOnEscInTitle.get()) {
            if (this.field_1229.field_3816 == this) {
                this.field_1229.method_2928(new ConfirmExitScreen(this.field_1229.field_3816));
                ci.cancel();
            }
        }
    }
}
