/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.metalica.datagen.models;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.redfox.metalica.datagen.models.MyModelBuilder;

public abstract class MyCustomLoaderBuilder<T extends MyModelBuilder<T>> {
    protected final ResourceLocation loaderId;
    protected final T parent;
    protected final ExistingFileHelper existingFileHelper;
    protected final Map<String, Boolean> visibility = new LinkedHashMap<String, Boolean>();

    protected MyCustomLoaderBuilder(ResourceLocation loaderId, T parent, ExistingFileHelper existingFileHelper) {
        this.loaderId = loaderId;
        this.parent = parent;
        this.existingFileHelper = existingFileHelper;
    }

    public MyCustomLoaderBuilder<T> visibility(String partName, boolean show) {
        Preconditions.checkNotNull((Object)partName, (Object)"partName must not be null");
        this.visibility.put(partName, show);
        return this;
    }

    public T end() {
        return this.parent;
    }

    public JsonObject toJson(JsonObject json) {
        json.addProperty("loader", this.loaderId.toString());
        if (this.visibility.size() > 0) {
            JsonObject visibilityObj = new JsonObject();
            for (Map.Entry<String, Boolean> entry : this.visibility.entrySet()) {
                visibilityObj.addProperty(entry.getKey(), entry.getValue());
            }
            json.add("visibility", (JsonElement)visibilityObj);
        }
        return json;
    }
}

