/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.metalica.material;

import java.util.ArrayList;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;
import net.redfox.metalica.block.ModBlocks;
import net.redfox.metalica.fluid.ModFluids;
import net.redfox.metalica.item.ModItems;
import net.redfox.metalica.util.ModTags;
import net.redfox.metalica.worldgen.WorldgenContext;
import slimeknights.mantle.registration.object.FlowingFluidObject;

public class MetalMaterial {
    private static final ArrayList<MetalMaterial> MATERIALS = new ArrayList();
    private final String displayName;
    private final String name;
    private final int color;
    private final RegistryObject<Block> stoneOre;
    private final RegistryObject<Block> deepslateOre;
    private final RegistryObject<Block> storageBlock;
    private final RegistryObject<Block> rawStorageBlock;
    private final RegistryObject<Item> ingot;
    private final RegistryObject<Item> nugget;
    private final RegistryObject<Item> dust;
    private final RegistryObject<Item> raw;
    private final FlowingFluidObject<ForgeFlowingFluid> fluid;
    private final TagKey<Block> oreMiningLevel;
    private final TagKey<Block> storageBlockMiningLevel;
    private final TagKey<Item> dustTag;
    private final TagKey<Item> ingotTag;
    private final TagKey<Item> nuggetTag;
    private final TagKey<Item> oreTag;
    private final TagKey<Item> rawTag;
    private final TagKey<Item> storageBlockTag;
    private final TagKey<Fluid> fluidTag;
    private final WorldgenContext worldgenContext;

    private MetalMaterial(String displayName, String name, int color, TagKey<Block> oreMiningLevel, TagKey<Block> storageBlockMiningLevel, WorldgenContext worldgenContext) {
        MATERIALS.add(this);
        this.displayName = displayName;
        this.name = name;
        this.color = color;
        this.worldgenContext = worldgenContext;
        if (worldgenContext != null) {
            this.stoneOre = ModBlocks.registerBlock(name + "_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49996_)));
            this.deepslateOre = ModBlocks.registerBlock("deepslate_" + name + "_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152468_)));
            this.rawStorageBlock = ModBlocks.registerBlock("raw_" + name + "_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152598_)));
            this.raw = ModItems.ITEMS.register("raw_" + name, () -> new Item(new Item.Properties()));
            this.oreTag = ModTags.Items.forgeTag("ores/" + name);
            this.rawTag = ModTags.Items.forgeTag("raw_materials/" + name);
        } else {
            this.stoneOre = null;
            this.deepslateOre = null;
            this.rawStorageBlock = null;
            this.raw = null;
            this.oreTag = null;
            this.rawTag = null;
        }
        this.storageBlock = ModBlocks.registerBlock(name + "_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
        this.ingot = ModItems.ITEMS.register(name + "_ingot", () -> new Item(new Item.Properties()));
        this.nugget = ModItems.ITEMS.register(name + "_nugget", () -> new Item(new Item.Properties()));
        this.dust = ModItems.ITEMS.register(name + "_dust", () -> new Item(new Item.Properties()));
        this.fluid = ModFluids.createMoltenFluid("molten_" + name);
        this.oreMiningLevel = oreMiningLevel;
        this.storageBlockMiningLevel = storageBlockMiningLevel;
        this.dustTag = ModTags.Items.forgeTag("dusts/" + name);
        this.ingotTag = ModTags.Items.forgeTag("ingots/" + name);
        this.nuggetTag = ModTags.Items.forgeTag("nuggets/" + name);
        this.storageBlockTag = ModTags.Items.forgeTag("storage_blocks/" + name);
        this.fluidTag = ModTags.Fluids.tag(name);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public int getColor() {
        return this.color;
    }

    public RegistryObject<Block> getStoneOre() {
        return this.stoneOre;
    }

    public RegistryObject<Block> getDeepslateOre() {
        return this.deepslateOre;
    }

    public RegistryObject<Block> getStorageBlock() {
        return this.storageBlock;
    }

    public RegistryObject<Block> getRawStorageBlock() {
        return this.rawStorageBlock;
    }

    public RegistryObject<Item> getIngot() {
        return this.ingot;
    }

    public RegistryObject<Item> getNugget() {
        return this.nugget;
    }

    public RegistryObject<Item> getDust() {
        return this.dust;
    }

    public RegistryObject<Item> getRaw() {
        return this.raw;
    }

    public FlowingFluidObject<ForgeFlowingFluid> getFluid() {
        return this.fluid;
    }

    public TagKey<Block> getOreMiningLevel() {
        return this.oreMiningLevel;
    }

    public TagKey<Block> getStorageBlockMiningLevel() {
        return this.storageBlockMiningLevel;
    }

    public TagKey<Item> getDustTag() {
        return this.dustTag;
    }

    public TagKey<Item> getIngotTag() {
        return this.ingotTag;
    }

    public TagKey<Item> getNuggetTag() {
        return this.nuggetTag;
    }

    public TagKey<Item> getOreTag() {
        return this.oreTag;
    }

    public TagKey<Item> getRawTag() {
        return this.rawTag;
    }

    public TagKey<Item> getStorageBlockTag() {
        return this.storageBlockTag;
    }

    public TagKey<Fluid> getFluidTag() {
        return this.fluidTag;
    }

    public WorldgenContext getWorldgenContext() {
        return this.worldgenContext;
    }

    public boolean hasOre() {
        return this.worldgenContext != null;
    }

    public static ArrayList<MetalMaterial> getMaterials() {
        return MATERIALS;
    }

    public static class Builder {
        private final String displayName;
        private final String name;
        private final int color;
        private WorldgenContext worldgenContext;
        private TagKey<Block> oreMiningLevel;
        private TagKey<Block> storageBlockMiningLevel;

        public Builder(String name, int color) {
            this.displayName = name.substring(0, 1).toUpperCase() + name.substring(1);
            this.name = name;
            this.color = color;
            this.oreMiningLevel = BlockTags.f_144286_;
            this.storageBlockMiningLevel = this.oreMiningLevel;
            this.worldgenContext = null;
        }

        public Builder storageBlockMiningLevel(TagKey<Block> miningLevel) {
            this.storageBlockMiningLevel = miningLevel;
            return this;
        }

        public Builder ore(int veinSize, int veinCount, int minY, int maxY, TagKey<Block> miningLevel) {
            this.worldgenContext = new WorldgenContext(this.name, veinSize, veinCount, minY, maxY);
            this.oreMiningLevel = miningLevel;
            return this;
        }

        public MetalMaterial build() {
            return new MetalMaterial(this.displayName, this.name, this.color, this.oreMiningLevel, this.storageBlockMiningLevel, this.worldgenContext);
        }
    }
}

