/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.metalica.worldgen;

import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.redfox.metalica.worldgen.ModBiomeModifiers;
import net.redfox.metalica.worldgen.ModConfiguredFeatures;
import net.redfox.metalica.worldgen.ModPlacedFeatures;

public class WorldgenContext {
    private final int veinSize;
    private final int veinCount;
    private final int minY;
    private final int maxY;
    private final ResourceKey<BiomeModifier> biomeResourceKey;
    private final ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureResourceKey;
    private final ResourceKey<PlacedFeature> placedFeatureResourceKey;

    public WorldgenContext(String name, int veinSize, int veinCount, int minY, int maxY) {
        this.veinSize = veinSize;
        this.veinCount = veinCount;
        this.minY = minY;
        this.maxY = maxY;
        this.biomeResourceKey = ModBiomeModifiers.registerKey("add_" + name + "_ore");
        this.configuredFeatureResourceKey = ModConfiguredFeatures.registerKey(name + "_ore");
        this.placedFeatureResourceKey = ModPlacedFeatures.registerKey(name + "_ore_placed");
    }

    public int getVeinSize() {
        return this.veinSize;
    }

    public int getVeinCount() {
        return this.veinCount;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public ResourceKey<BiomeModifier> getBiomeResourceKey() {
        return this.biomeResourceKey;
    }

    public ResourceKey<ConfiguredFeature<?, ?>> getConfiguredFeatureResourceKey() {
        return this.configuredFeatureResourceKey;
    }

    public ResourceKey<PlacedFeature> getPlacedFeatureResourceKey() {
        return this.placedFeatureResourceKey;
    }
}

