/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.metalica.compat.tconstruct.datagen;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.resources.ResourceLocation;
import net.redfox.metalica.material.MetalMaterial;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.spritetransformer.GreyToColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.IColorMapping;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;

public class TinkersMaterialSpriteProvider
extends AbstractMaterialSpriteProvider {
    public static Color[] getColorPixels(String name) {
        Color[] colorPixels = new Color[8];
        try {
            BufferedImage color = ImageIO.read(TinkersMaterialSpriteProvider.class.getResourceAsStream("/assets/metalica/textures/color/" + name + ".png"));
            for (int i = 0; i < 8; ++i) {
                colorPixels[i] = new Color(color.getRGB(0, i));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return colorPixels;
    }

    @NotNull
    public String getName() {
        return "TinkersMaterialSpriteProvider";
    }

    protected void addAllMaterials() {
        for (MetalMaterial material : MetalMaterial.getMaterials()) {
            Color[] colorPixels = TinkersMaterialSpriteProvider.getColorPixels(material.getName());
            this.buildMaterial(new MaterialId(ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)material.getName()))).statType(new MaterialStatsId(ResourceLocation.fromNamespaceAndPath((String)"tconstruct", (String)"limb"))).colorMapper((IColorMapping)GreyToColorMapping.builder().addABGR(0, colorPixels[0].getRGB()).addABGR(63, colorPixels[1].getRGB()).addABGR(102, colorPixels[2].getRGB()).addABGR(140, colorPixels[3].getRGB()).addABGR(178, colorPixels[4].getRGB()).addABGR(216, colorPixels[5].getRGB()).addABGR(255, colorPixels[7].getRGB()).build());
        }
    }
}

