/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.metalica.datagen;

import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.redfox.metalica.datagen.models.MyBlockModelBuilder;
import net.redfox.metalica.datagen.models.MyBlockStateProvider;
import net.redfox.metalica.material.MetalMaterial;

public class ModBlockStateProvider
extends MyBlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "metalica", exFileHelper);
    }

    @Override
    protected void registerStatesAndModels() {
        for (MetalMaterial material : MetalMaterial.getMaterials()) {
            this.simpleBlock((Block)material.getFluid().getBlock());
            this.blockWithItem(material.getName() + "_block", ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)("block/storage_block_" + material.getName())));
            this.simpleBlockWithItem((Block)material.getStorageBlock().get(), (ModelFile)this.models().getExistingFile(this.modLoc(material.getName() + "_block")));
            if (!material.hasOre()) continue;
            this.blockWithItem("raw_" + material.getName() + "_block", ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)("block/raw_storage_block_" + material.getName())));
            this.simpleBlockWithItem((Block)material.getRawStorageBlock().get(), (ModelFile)this.models().getExistingFile(this.modLoc("raw_" + material.getName() + "_block")));
            this.layeredOreBlock(material.getName() + "_ore", "block/stone", "metalica:block/ore_" + material.getName());
            this.simpleBlockWithItem((Block)material.getStoneOre().get(), (ModelFile)this.models().getExistingFile(this.modLoc(material.getName() + "_ore")));
            this.layeredOreBlock("deepslate_" + material.getName() + "_ore", "block/deepslate", "metalica:block/ore_" + material.getName());
            this.simpleBlockWithItem((Block)material.getDeepslateOre().get(), (ModelFile)this.models().getExistingFile(this.modLoc("deepslate_" + material.getName() + "_ore")));
        }
    }

    private void blockWithItem(String name, ResourceLocation texture) {
        this.models().cubeAll(name, texture);
    }

    public ModelFile layeredOreBlock(String name, String baseTexturePath, String overlayTexturePath) {
        ResourceLocation particleTexture = ResourceLocation.parse((String)baseTexturePath);
        ResourceLocation sideTexture = ResourceLocation.parse((String)baseTexturePath);
        ResourceLocation overlayTexture = ResourceLocation.parse((String)overlayTexturePath);
        Object model = ((MyBlockModelBuilder)((Object)((MyBlockModelBuilder)((Object)((MyBlockModelBuilder)((Object)((MyBlockModelBuilder)((Object)((MyBlockModelBuilder)((Object)((MyBlockModelBuilder)((Object)((MyBlockModelBuilder)((Object)this.models().getBuilder(name))).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/block"))))).renderType("cutout"))).texture("particle", particleTexture))).texture("side", sideTexture))).texture("overlay", overlayTexture))).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#side").cullface(Direction.DOWN).end().face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#side").cullface(Direction.UP).end().face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#side").cullface(Direction.NORTH).end().face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#side").cullface(Direction.SOUTH).end().face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#side").cullface(Direction.WEST).end().face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#side").cullface(Direction.EAST).end().end())).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#overlay").cullface(Direction.NORTH).end().face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#overlay").cullface(Direction.SOUTH).end().face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#overlay").cullface(Direction.WEST).end().face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#overlay").cullface(Direction.EAST).end().face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#overlay").cullface(Direction.UP).end().face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#overlay").cullface(Direction.DOWN).end().end();
        return model;
    }
}

