/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.metalica.worldgen;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.redfox.metalica.material.MetalMaterial;

public class ModConfiguredFeatures {
    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplacable = new TagMatchTest(BlockTags.f_144266_);
        TagMatchTest deepslateReplacable = new TagMatchTest(BlockTags.f_144267_);
        for (MetalMaterial material : MetalMaterial.getMaterials()) {
            if (!material.hasOre()) continue;
            List<OreConfiguration.TargetBlockState> ores = List.of(OreConfiguration.m_161021_((RuleTest)stoneReplacable, (BlockState)((Block)material.getStoneOre().get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateReplacable, (BlockState)((Block)material.getDeepslateOre().get()).m_49966_()));
            ModConfiguredFeatures.register(context, material.getWorldgenContext().getConfiguredFeatureResourceKey(), Feature.f_65731_, new OreConfiguration(ores, material.getWorldgenContext().getVeinSize()));
        }
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

