/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.metalica.compat.tconstruct.datagen.owned;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.library.data.material.AbstractMaterialDataProvider;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.json.MaterialStatJson;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.tools.modules.ArmorModuleBuilder;

public abstract class MyAbstractMaterialStatsDataProvider
extends GenericDataProvider {
    private final Map<MaterialId, List<IMaterialStats>> allMaterialStats = new HashMap<MaterialId, List<IMaterialStats>>();
    private final AbstractMaterialDataProvider materials;

    public MyAbstractMaterialStatsDataProvider(PackOutput packOutput, AbstractMaterialDataProvider materials) {
        super(packOutput, PackOutput.Target.DATA_PACK, "tinkering/materials/stats");
        this.materials = materials;
    }

    protected abstract void addMaterialStats();

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addMaterialStats();
        return MyAbstractMaterialStatsDataProvider.allOf(this.allMaterialStats.entrySet().stream().map(entry -> this.saveJson(cache, (ResourceLocation)entry.getKey(), this.convert((List)entry.getValue()))));
    }

    protected void addMaterialStats(MaterialId location, IMaterialStats ... stats) {
        this.allMaterialStats.computeIfAbsent(location, materialId -> new ArrayList()).addAll(Arrays.asList(stats));
    }

    protected void addArmorStats(MaterialId location, ArmorModuleBuilder<? extends IMaterialStats> statBuilder, IMaterialStats ... otherStats) {
        IMaterialStats[] stats = new IMaterialStats[4];
        for (ArmorItem.Type slotType : ArmorItem.Type.values()) {
            stats[slotType.ordinal()] = (IMaterialStats)statBuilder.build(slotType);
        }
        this.addMaterialStats(location, stats);
        if (otherStats.length > 0) {
            this.addMaterialStats(location, otherStats);
        }
    }

    protected void addArmorShieldStats(MaterialId location, ArmorModuleBuilder.ArmorShieldModuleBuilder<? extends IMaterialStats> statBuilder, IMaterialStats ... otherStats) {
        this.addArmorStats(location, (ArmorModuleBuilder<? extends IMaterialStats>)statBuilder, otherStats);
        this.addMaterialStats(location, (IMaterialStats)statBuilder.buildShield());
    }

    private MaterialStatJson convert(List<IMaterialStats> stats) {
        return new MaterialStatJson(stats.stream().collect(Collectors.toMap(IMaterialStats::getIdentifier, stat -> MyAbstractMaterialStatsDataProvider.encodeStats(stat, stat.getType()))));
    }

    private static <T extends IMaterialStats> JsonElement encodeStats(IMaterialStats stats, MaterialStatType<T> type) {
        return type.getLoadable().serialize((Object)stats);
    }
}

