/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.metalica.compat.tconstruct.datagen.owned;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.library.data.material.AbstractMaterialDataProvider;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.materials.traits.MaterialTraits;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;

public abstract class MyAbstractMaterialTraitDataProvider
extends GenericDataProvider {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ModifierEntry.class, (Object)ModifierEntry.LOADABLE).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<MaterialId, MaterialTraits.Builder> allMaterialTraits = new HashMap<MaterialId, MaterialTraits.Builder>();
    private final AbstractMaterialDataProvider materials;

    public MyAbstractMaterialTraitDataProvider(PackOutput packOutput, AbstractMaterialDataProvider materials) {
        super(packOutput, PackOutput.Target.DATA_PACK, "tinkering/materials/traits", GSON);
        this.materials = materials;
    }

    protected abstract void addMaterialTraits();

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addMaterialTraits();
        return MyAbstractMaterialTraitDataProvider.allOf(this.allMaterialTraits.entrySet().stream().map(entry -> this.saveJson(cache, (ResourceLocation)entry.getKey(), ((MaterialTraits.Builder)entry.getValue()).serialize())));
    }

    private MaterialTraits.Builder getOrCreateMaterialTraits(MaterialId location) {
        return this.allMaterialTraits.computeIfAbsent(location, id -> new MaterialTraits.Builder());
    }

    protected void noTraits(MaterialId location) {
        this.getOrCreateMaterialTraits(location);
    }

    protected void addDefaultTraits(MaterialId location, ModifierEntry ... traits) {
        this.getOrCreateMaterialTraits(location).setDefaultTraits(Arrays.asList(traits));
    }

    protected void addDefaultTraits(MaterialId location, ModifierId ... traits) {
        this.getOrCreateMaterialTraits(location).setDefaultTraits(Arrays.stream(traits).map(trait -> new ModifierEntry(trait, 1)).collect(Collectors.toList()));
    }

    protected void addDefaultTraits(MaterialId location, LazyModifier ... traits) {
        this.getOrCreateMaterialTraits(location).setDefaultTraits(Arrays.stream(traits).map(trait -> new ModifierEntry(trait.getId(), 1)).collect(Collectors.toList()));
    }

    protected void addTraits(MaterialId location, MaterialStatsId statsId, ModifierEntry ... traits) {
        this.getOrCreateMaterialTraits(location).setTraits(statsId, Arrays.asList(traits));
    }

    protected void addTraits(MaterialId location, MaterialStatsId statsId, ModifierId ... traits) {
        this.getOrCreateMaterialTraits(location).setTraits(statsId, Arrays.stream(traits).map(trait -> new ModifierEntry(trait, 1)).collect(Collectors.toList()));
    }

    protected void addTraits(MaterialId location, MaterialStatsId statsId, LazyModifier ... traits) {
        this.getOrCreateMaterialTraits(location).setTraits(statsId, Arrays.stream(traits).map(trait -> new ModifierEntry(trait.getId(), 1)).collect(Collectors.toList()));
    }
}

