/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.metalica.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.redfox.metalica.compat.tconstruct.datagen.TinkersDataAdder;
import net.redfox.metalica.datagen.ModAtlasProvider;
import net.redfox.metalica.datagen.ModBlockStateProvider;
import net.redfox.metalica.datagen.ModBlockTagProvider;
import net.redfox.metalica.datagen.ModFluidTagProvider;
import net.redfox.metalica.datagen.ModFluidTextureProvider;
import net.redfox.metalica.datagen.ModItemModelProvider;
import net.redfox.metalica.datagen.ModItemTagProvider;
import net.redfox.metalica.datagen.ModLanguageProvider;
import net.redfox.metalica.datagen.ModLootTableProvider;
import net.redfox.metalica.datagen.ModRecipeProvider;
import net.redfox.metalica.datagen.ModWorldGenProvider;

@Mod.EventBusSubscriber(modid="metalica", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new ModAtlasProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.create(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(packOutput, "en_us"));
        generator.addProvider(event.includeClient(), (DataProvider)new ModFluidTextureProvider(packOutput));
        ModBlockTagProvider blockTagProvider = (ModBlockTagProvider)generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, blockTagProvider.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModFluidTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModWorldGenProvider(packOutput, lookupProvider));
        TinkersDataAdder.addData(generator, event, packOutput, existingFileHelper);
    }
}

