/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.metalica.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.redfox.metalica.datagen.models.MyItemModelBuilder;
import net.redfox.metalica.datagen.models.MyItemModelProvider;
import net.redfox.metalica.material.MetalMaterial;

public class ModItemModelProvider
extends MyItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "metalica", existingFileHelper);
    }

    @Override
    protected void registerModels() {
        for (MetalMaterial material : MetalMaterial.getMaterials()) {
            this.simpleItem((Item)material.getIngot().get(), "ingot_" + material.getName());
            this.simpleItem((Item)material.getDust().get(), "dust_" + material.getName());
            this.simpleItem((Item)material.getNugget().get(), "nugget_" + material.getName());
            this.bucketItem(material.getFluid().getBucket(), "liquid_" + material.getName());
            if (!material.hasOre()) continue;
            this.simpleItem((Item)material.getRaw().get(), "raw_" + material.getName());
        }
    }

    private MyItemModelBuilder simpleItem(Item item, String modelName) {
        String itemName = item.m_5524_().substring(item.m_5524_().indexOf("metalica") + 1 + "metalica".length());
        return (MyItemModelBuilder)((Object)((MyItemModelBuilder)((Object)this.withExistingParent("metalica:item/" + itemName, ResourceLocation.parse((String)"item/generated")))).texture("layer0", "metalica:item/" + modelName));
    }

    private MyItemModelBuilder bucketItem(Item item, String modelName) {
        String itemName = item.m_5524_().substring(item.m_5524_().indexOf("metalica") + 1 + "metalica".length());
        return (MyItemModelBuilder)((Object)((MyItemModelBuilder)((Object)((MyItemModelBuilder)((Object)this.withExistingParent("metalica:item/" + itemName, ResourceLocation.parse((String)"item/generated")))).texture("layer0", ResourceLocation.withDefaultNamespace((String)"item/bucket")))).texture("layer1", "metalica:item/" + modelName));
    }
}

