/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.metalica.datagen;

import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.LanguageProvider;
import net.redfox.metalica.material.MetalMaterial;

public class ModLanguageProvider
extends LanguageProvider {
    public ModLanguageProvider(PackOutput output, String locale) {
        super(output, "metalica", locale);
    }

    protected void addTranslations() {
        this.add("creativetab.metalica.metalica_tab", "Metalica");
        for (MetalMaterial material : MetalMaterial.getMaterials()) {
            this.add("block.metalica." + material.getName() + "_block", material.getDisplayName() + " Block");
            this.add("item.metalica." + material.getName() + "_ingot", material.getDisplayName() + " Ingot");
            this.add("item.metalica." + material.getName() + "_dust", material.getDisplayName() + " Dust");
            this.add("item.metalica." + material.getName() + "_nugget", material.getDisplayName() + " Nugget");
            this.add("item.metalica.molten_" + material.getName() + "_bucket", "Molten " + material.getDisplayName() + " Bucket");
            this.add("fluid.metalica.molten_" + material.getName(), "Molten " + material.getDisplayName());
            if (material.hasOre()) {
                this.add("block.metalica.deepslate_" + material.getName() + "_ore", "Deepslate " + material.getDisplayName() + " Ore");
                this.add("block.metalica." + material.getName() + "_ore", material.getDisplayName() + " Ore");
                this.add("item.metalica.raw_" + material.getName(), "Raw " + material.getDisplayName());
                this.add("block.metalica.raw_" + material.getName() + "_block", "Raw " + material.getDisplayName() + " Block");
            }
            if (material.getTinkersMaterialBuilder() == null) continue;
            this.add("material.metalica." + material.getName(), material.getDisplayName());
        }
    }
}

