/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.metalica.datagen;

import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.fluids.FluidStack;
import net.redfox.metalica.material.MetalMaterial;
import net.redfox.metalica.util.ModTags;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipeBuilder;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.MaterialMeltingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(PackOutput pOutput) {
        super(pOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> pWriter) {
        for (MetalMaterial material : MetalMaterial.getMaterials()) {
            ModRecipeProvider.compactingRecipe(pWriter, material.getIngotTag(), (ItemLike)material.getIngot().get(), (ItemLike)material.getStorageBlock().get(), ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/crafting/block_from_ingot")));
            ModRecipeProvider.unCompactingRecipe(pWriter, material.getStorageBlockTag(), (ItemLike)material.getStorageBlock().get(), (ItemLike)material.getIngot().get(), ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/crafting/ingot_from_block")));
            ModRecipeProvider.compactingRecipe(pWriter, material.getNuggetTag(), (ItemLike)material.getNugget().get(), (ItemLike)material.getIngot().get(), ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/crafting/ingot_from_nugget")));
            ModRecipeProvider.unCompactingRecipe(pWriter, material.getIngotTag(), (ItemLike)material.getIngot().get(), (ItemLike)material.getNugget().get(), ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/crafting/nugget_from_ingot")));
            ModRecipeProvider.oreSmelting(pWriter, material.getDustTag(), (ItemLike)material.getDust().get(), (ItemLike)material.getIngot().get(), 0.0f, 200, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/smelting/ingot_from_dust")));
            ModRecipeProvider.oreBlasting(pWriter, material.getDustTag(), (ItemLike)material.getDust().get(), (ItemLike)material.getIngot().get(), 0.0f, 200, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/blasting/ingot_from_dust")));
            MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_(material.getIngotTag()), (Fluid)material.getFluid().get(), (int)90, (float)1.0f).save(pWriter, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/melting/fluid_from_ingot")));
            MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_(material.getDustTag()), (Fluid)material.getFluid().get(), (int)90, (float)1.0f).save(pWriter, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/melting/fluid_from_dust")));
            MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_(material.getNuggetTag()), (Fluid)material.getFluid().get(), (int)10, (float)1.0f).save(pWriter, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/melting/fluid_from_nugget")));
            MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_(material.getStorageBlockTag()), (Fluid)material.getFluid().get(), (int)810, (float)1.0f).save(pWriter, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/melting/fluid_from_block")));
            ItemCastingRecipeBuilder.basinRecipe(material.getStorageBlockTag()).setFluid(material.getFluidTag(), 810).setCoolingTime(180).save(pWriter, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/casting/basin/block")));
            ItemCastingRecipeBuilder.tableRecipe(material.getIngotTag()).setFluid(material.getFluidTag(), 90).setCoolingTime(60).setCast(ModTags.Items.REUSABLE_INGOT_CAST_TAG, false).save(pWriter, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/casting/table/reusable/ingot")));
            ItemCastingRecipeBuilder.tableRecipe(material.getIngotTag()).setFluid(material.getFluidTag(), 90).setCoolingTime(60).setCast(ModTags.Items.SINGLE_USE_INGOT_CAST_TAG, true).save(pWriter, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/casting/table/single_use/ingot")));
            ItemCastingRecipeBuilder.tableRecipe(material.getNuggetTag()).setFluid(material.getFluidTag(), 10).setCoolingTime(20).setCast(ModTags.Items.REUSABLE_NUGGET_CAST_TAG, false).save(pWriter, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/casting/table/reusable/nugget")));
            ItemCastingRecipeBuilder.tableRecipe(material.getNuggetTag()).setFluid(material.getFluidTag(), 10).setCoolingTime(20).setCast(ModTags.Items.SINGLE_USE_NUGGET_CAST_TAG, true).save(pWriter, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/casting/table/single_use/nugget")));
            if (material.getTinkersMaterialBuilder() != null) {
                MaterialRecipeBuilder.materialRecipe((MaterialVariantId)new MaterialId(ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)material.getName()))).setIngredient(material.getIngotTag()).save(pWriter, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/casting/table/single_use/material_item")));
                MaterialFluidRecipeBuilder.material((MaterialVariantId)new MaterialId(ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)material.getName()))).setFluid((FluidIngredient)FluidIngredient.of(material.getFluidTag(), (int)90)).setTemperature(material.getTinkersMaterialBuilder().getTemperature()).save(pWriter, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/casting/table/single_use/material_fluid")));
                MaterialMeltingRecipeBuilder.material((MaterialVariantId)new MaterialId(ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)material.getName())), (int)material.getTinkersMaterialBuilder().getTemperature(), (FluidStack)new FluidStack(material.getFluid().get(), 90)).save(pWriter, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/casting/table/single_use/material_melting")));
            }
            if (!material.hasOre()) continue;
            MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_(material.getRawTag()), (Fluid)material.getFluid().get(), (int)90, (float)1.0f).save(pWriter, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/melting/fluid_from_raw")));
            MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_(material.getRawStorageBlockTag()), (Fluid)material.getFluid().get(), (int)810, (float)1.0f).save(pWriter, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/melting/fluid_from_raw_block")));
            MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_(material.getOreTag()), (Fluid)material.getFluid().get(), (int)90, (float)1.0f).save(pWriter, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/melting/fluid_from_ore")));
            ModRecipeProvider.oreSmelting(pWriter, material.getRawTag(), (ItemLike)material.getRaw().get(), (ItemLike)material.getIngot().get(), 0.25f, 200, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/smelting/ingot_from_raw")));
            ModRecipeProvider.oreBlasting(pWriter, material.getRawTag(), (ItemLike)material.getRaw().get(), (ItemLike)material.getIngot().get(), 0.25f, 200, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/blasting/ingot_from_raw")));
            ModRecipeProvider.oreSmelting(pWriter, material.getOreTag(), (ItemLike)material.getStoneOre().get(), (ItemLike)material.getIngot().get(), 0.25f, 200, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/smelting/ingot_from_ore")));
            ModRecipeProvider.oreBlasting(pWriter, material.getOreTag(), (ItemLike)material.getStoneOre().get(), (ItemLike)material.getIngot().get(), 0.25f, 200, ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/blasting/ingot_from_ore")));
            ModRecipeProvider.compactingRecipe(pWriter, material.getRawTag(), (ItemLike)material.getRaw().get(), (ItemLike)material.getRawStorageBlock().get(), ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/crafting/raw_from_raw_block")));
            ModRecipeProvider.unCompactingRecipe(pWriter, material.getRawStorageBlockTag(), (ItemLike)material.getRawStorageBlock().get(), (ItemLike)material.getRaw().get(), ResourceLocation.fromNamespaceAndPath((String)"metalica", (String)(material.getName() + "/crafting/raw_block_from_raw")));
        }
    }

    protected static void oreSmelting(Consumer<FinishedRecipe> pFinishedRecipeConsumer, TagKey<Item> inputTag, ItemLike input, ItemLike pResult, float pExperience, int pCookingTIme, ResourceLocation savePath) {
        ModRecipeProvider.oreCooking(pFinishedRecipeConsumer, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44091_, inputTag, input, pResult, pExperience, pCookingTIme, savePath);
    }

    protected static void oreBlasting(Consumer<FinishedRecipe> pFinishedRecipeConsumer, TagKey<Item> inputTag, ItemLike input, ItemLike pResult, float pExperience, int pCookingTime, ResourceLocation savePath) {
        ModRecipeProvider.oreCooking(pFinishedRecipeConsumer, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44092_, inputTag, input, pResult, pExperience, pCookingTime, savePath);
    }

    protected static void oreCooking(Consumer<FinishedRecipe> pFinishedRecipeConsumer, RecipeSerializer<? extends AbstractCookingRecipe> pCookingSerializer, TagKey<Item> inputTag, ItemLike input, ItemLike pResult, float pExperience, int pCookingTime, ResourceLocation savePath) {
        SimpleCookingRecipeBuilder.m_247607_((Ingredient)Ingredient.m_204132_(inputTag), (RecipeCategory)RecipeCategory.MISC, (ItemLike)pResult, (float)pExperience, (int)pCookingTime, pCookingSerializer).m_126132_(ModRecipeProvider.m_176602_((ItemLike)input), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)input)).m_126140_(pFinishedRecipeConsumer, savePath);
    }

    private static void compactingRecipe(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> unpackedTag, ItemLike unpacked, ItemLike packed, ResourceLocation savePath) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)packed).m_206416_(Character.valueOf('#'), unpackedTag).m_126130_("###").m_126130_("###").m_126130_("###").m_126132_(ModRecipeProvider.m_176602_((ItemLike)unpacked), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)unpacked)).m_126140_(finishedRecipeConsumer, savePath);
    }

    private static void unCompactingRecipe(Consumer<FinishedRecipe> finishedRecipeConsumer, TagKey<Item> packedTag, ItemLike packed, ItemLike unpacked, ResourceLocation savePath) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)unpacked, (int)9).m_206419_(packedTag).m_126132_(ModRecipeProvider.m_176602_((ItemLike)packed), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)packed)).m_126140_(finishedRecipeConsumer, savePath);
    }
}

