/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.metalica.datagen.models;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ObjectArrays;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraftforge.client.model.generators.ModelFile;
import net.redfox.metalica.datagen.models.MyBlockStateProvider;
import net.redfox.metalica.datagen.models.MyMultiPartBlockStateBuilder;
import net.redfox.metalica.datagen.models.MyVariantBlockStateBuilder;
import org.jetbrains.annotations.Nullable;

public final class MyConfiguredModel {
    public static final int DEFAULT_WEIGHT = 1;
    public final ModelFile model;
    public final int rotationX;
    public final int rotationY;
    public final boolean uvLock;
    public final int weight;

    private static IntStream validRotations() {
        return IntStream.range(0, 4).map(i -> i * 90);
    }

    public static MyConfiguredModel[] allYRotations(ModelFile model, int x, boolean uvlock) {
        return MyConfiguredModel.allYRotations(model, x, uvlock, 1);
    }

    public static MyConfiguredModel[] allYRotations(ModelFile model, int x, boolean uvlock, int weight) {
        return (MyConfiguredModel[])MyConfiguredModel.validRotations().mapToObj(y -> new MyConfiguredModel(model, x, y, uvlock, weight)).toArray(MyConfiguredModel[]::new);
    }

    public static MyConfiguredModel[] allRotations(ModelFile model, boolean uvlock) {
        return MyConfiguredModel.allRotations(model, uvlock, 1);
    }

    public static MyConfiguredModel[] allRotations(ModelFile model, boolean uvlock, int weight) {
        return (MyConfiguredModel[])MyConfiguredModel.validRotations().mapToObj(x -> MyConfiguredModel.allYRotations(model, x, uvlock, weight)).flatMap(Arrays::stream).toArray(MyConfiguredModel[]::new);
    }

    public MyConfiguredModel(ModelFile model, int rotationX, int rotationY, boolean uvLock, int weight) {
        Preconditions.checkNotNull((Object)model);
        this.model = model;
        MyConfiguredModel.checkRotation(rotationX, rotationY);
        this.rotationX = rotationX;
        this.rotationY = rotationY;
        this.uvLock = uvLock;
        MyConfiguredModel.checkWeight(weight);
        this.weight = weight;
    }

    public MyConfiguredModel(ModelFile model, int rotationX, int rotationY, boolean uvLock) {
        this(model, rotationX, rotationY, uvLock, 1);
    }

    public MyConfiguredModel(ModelFile model) {
        this(model, 0, 0, false);
    }

    static void checkRotation(int rotationX, int rotationY) {
        Preconditions.checkArgument((BlockModelRotation.m_119153_((int)rotationX, (int)rotationY) != null ? 1 : 0) != 0, (String)"Invalid model rotation x=%d, y=%d", (int)rotationX, (int)rotationY);
    }

    static void checkWeight(int weight) {
        Preconditions.checkArgument((weight >= 1 ? 1 : 0) != 0, (String)"Model weight must be greater than or equal to 1. Found: %d", (int)weight);
    }

    JsonObject toJSON(boolean includeWeight) {
        JsonObject modelJson = new JsonObject();
        modelJson.addProperty("model", this.model.getLocation().toString());
        if (this.rotationX != 0) {
            modelJson.addProperty("x", (Number)this.rotationX);
        }
        if (this.rotationY != 0) {
            modelJson.addProperty("y", (Number)this.rotationY);
        }
        if (this.uvLock) {
            modelJson.addProperty("uvlock", Boolean.valueOf(this.uvLock));
        }
        if (includeWeight && this.weight != 1) {
            modelJson.addProperty("weight", (Number)this.weight);
        }
        return modelJson;
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    static Builder<MyVariantBlockStateBuilder> builder(MyVariantBlockStateBuilder outer, MyVariantBlockStateBuilder.PartialBlockstate state) {
        return new Builder<MyVariantBlockStateBuilder>(models -> outer.setModels(state, (MyConfiguredModel)models), (List<MyConfiguredModel>)ImmutableList.of());
    }

    static Builder<MyMultiPartBlockStateBuilder.PartBuilder> builder(MyMultiPartBlockStateBuilder outer) {
        return new Builder<MyMultiPartBlockStateBuilder.PartBuilder>(models -> {
            MyMultiPartBlockStateBuilder myMultiPartBlockStateBuilder = outer;
            Objects.requireNonNull(myMultiPartBlockStateBuilder);
            MyMultiPartBlockStateBuilder.PartBuilder ret = new MyMultiPartBlockStateBuilder.PartBuilder(myMultiPartBlockStateBuilder, new MyBlockStateProvider.ConfiguredModelList((MyConfiguredModel)models));
            outer.addPart(ret);
            return ret;
        }, (List<MyConfiguredModel>)ImmutableList.of());
    }

    public static class Builder<T> {
        private ModelFile model;
        @Nullable
        private final Function<MyConfiguredModel[], T> callback;
        private final List<MyConfiguredModel> otherModels;
        private int rotationX;
        private int rotationY;
        private boolean uvLock;
        private int weight = 1;

        Builder() {
            this(null, (List<MyConfiguredModel>)ImmutableList.of());
        }

        Builder(@Nullable Function<MyConfiguredModel[], T> callback, List<MyConfiguredModel> otherModels) {
            this.callback = callback;
            this.otherModels = otherModels;
        }

        public Builder<T> modelFile(ModelFile model) {
            Preconditions.checkNotNull((Object)model, (Object)"Model must not be null");
            this.model = model;
            return this;
        }

        public Builder<T> rotationX(int value) {
            MyConfiguredModel.checkRotation(value, this.rotationY);
            this.rotationX = value;
            return this;
        }

        public Builder<T> rotationY(int value) {
            MyConfiguredModel.checkRotation(this.rotationX, value);
            this.rotationY = value;
            return this;
        }

        public Builder<T> uvLock(boolean value) {
            this.uvLock = value;
            return this;
        }

        public Builder<T> weight(int value) {
            MyConfiguredModel.checkWeight(value);
            this.weight = value;
            return this;
        }

        public MyConfiguredModel buildLast() {
            return new MyConfiguredModel(this.model, this.rotationX, this.rotationY, this.uvLock, this.weight);
        }

        public MyConfiguredModel[] build() {
            return (MyConfiguredModel[])ObjectArrays.concat((Object[])this.otherModels.toArray(new MyConfiguredModel[0]), (Object)this.buildLast());
        }

        public T addModel() {
            Preconditions.checkNotNull(this.callback, (Object)"Cannot use addModel() without an owning builder present");
            return this.callback.apply(this.build());
        }

        public Builder<T> nextModel() {
            return new Builder<T>(this.callback, Arrays.asList(this.build()));
        }
    }
}

