/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.metalica.material;

import java.util.ArrayList;
import net.minecraft.world.item.Tier;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;
import slimeknights.tconstruct.tools.stats.PlatingMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class TinkersMaterialBuilder {
    private final ArrayList<IMaterialStats> statList = new ArrayList();
    private HeadMaterialStats headStats;
    private HandleMaterialStats handleStats;
    private PlatingMaterialStats helmetStats;
    private PlatingMaterialStats chestplateStats;
    private PlatingMaterialStats leggingsStats;
    private PlatingMaterialStats bootsStats;
    private PlatingMaterialStats shieldStats;
    private GripMaterialStats gripStats;
    private LimbMaterialStats limbStats;
    private StatlessMaterialStats binding;
    private StatlessMaterialStats bowstring;
    private StatlessMaterialStats maille;
    private StatlessMaterialStats shieldCore;
    private StatlessMaterialStats repairKit;
    private String modifier;
    private final Tier tier;
    private final int temperature;

    public TinkersMaterialBuilder(Tier tier, int temperature) {
        this.tier = tier;
        this.temperature = temperature;
    }

    public TinkersMaterialBuilder modifier(String modifier) {
        this.modifier = modifier;
        return this;
    }

    public TinkersMaterialBuilder head(int durability, float miningSpeed, float attackDamage) {
        this.headStats = new HeadMaterialStats(durability, miningSpeed, this.tier, attackDamage);
        this.statList.add((IMaterialStats)this.headStats);
        return this;
    }

    public TinkersMaterialBuilder handle(float durability, float miningSpeed, float meleeSpeed, float attackDamage) {
        this.handleStats = new HandleMaterialStats(durability, miningSpeed, meleeSpeed, attackDamage);
        this.statList.add((IMaterialStats)this.handleStats);
        return this;
    }

    public TinkersMaterialBuilder helmet(int durability, float armor, float armorToughness, float knockbackResistance) {
        this.helmetStats = new PlatingMaterialStats(PlatingMaterialStats.HELMET, durability, armor, armorToughness, knockbackResistance);
        this.statList.add((IMaterialStats)this.helmetStats);
        return this;
    }

    public TinkersMaterialBuilder chestplate(int durability, float armor, float armorToughness, float knockbackResistance) {
        this.chestplateStats = new PlatingMaterialStats(PlatingMaterialStats.CHESTPLATE, durability, armor, armorToughness, knockbackResistance);
        this.statList.add((IMaterialStats)this.chestplateStats);
        return this;
    }

    public TinkersMaterialBuilder leggings(int durability, float armor, float armorToughness, float knockbackResistance) {
        this.leggingsStats = new PlatingMaterialStats(PlatingMaterialStats.LEGGINGS, durability, armor, armorToughness, knockbackResistance);
        this.statList.add((IMaterialStats)this.leggingsStats);
        return this;
    }

    public TinkersMaterialBuilder boots(int durability, float armor, float armorToughness, float knockbackResistance) {
        this.bootsStats = new PlatingMaterialStats(PlatingMaterialStats.BOOTS, durability, armor, armorToughness, knockbackResistance);
        this.statList.add((IMaterialStats)this.bootsStats);
        return this;
    }

    public TinkersMaterialBuilder shield(int durability, float armor, float armorToughness, float knockbackResistance) {
        this.shieldStats = new PlatingMaterialStats(PlatingMaterialStats.SHIELD, durability, armor, armorToughness, knockbackResistance);
        this.statList.add((IMaterialStats)this.shieldStats);
        return this;
    }

    public TinkersMaterialBuilder grip(float durability, float accuracy, float meleeDamage) {
        this.gripStats = new GripMaterialStats(durability, accuracy, meleeDamage);
        this.statList.add((IMaterialStats)this.gripStats);
        return this;
    }

    public TinkersMaterialBuilder limb(int durability, float drawSpeed, float velocity, float accuracy) {
        this.limbStats = new LimbMaterialStats(durability, drawSpeed, velocity, accuracy);
        this.statList.add((IMaterialStats)this.limbStats);
        return this;
    }

    public TinkersMaterialBuilder binding() {
        this.binding = StatlessMaterialStats.BINDING;
        this.statList.add((IMaterialStats)this.binding);
        return this;
    }

    public TinkersMaterialBuilder bowstring() {
        this.bowstring = StatlessMaterialStats.BOWSTRING;
        this.statList.add((IMaterialStats)this.bowstring);
        return this;
    }

    public TinkersMaterialBuilder maille() {
        this.maille = StatlessMaterialStats.MAILLE;
        this.statList.add((IMaterialStats)this.maille);
        return this;
    }

    public TinkersMaterialBuilder sheildCore() {
        this.shieldCore = StatlessMaterialStats.SHIELD_CORE;
        this.statList.add((IMaterialStats)this.shieldCore);
        return this;
    }

    public TinkersMaterialBuilder repairKit() {
        this.repairKit = StatlessMaterialStats.REPAIR_KIT;
        this.statList.add((IMaterialStats)this.repairKit);
        return this;
    }

    public Tier getTier() {
        return this.tier;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public String getModifier() {
        return this.modifier;
    }

    public ArrayList<IMaterialStats> getStatList() {
        return this.statList;
    }
}

