/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.client.api;

import com.github.razorplay01.ismah.client.api.CustomArmorRenderer;
import com.github.razorplay01.ismah.common.mixin.InventoryAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_10192;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_9334;

public class ArmorRendererRegistry {
    private static final List<CustomArmorRenderer> renderers = new ArrayList<CustomArmorRenderer>();
    private static final List<Function<class_1657, class_1799>> chestplateProviders = new ArrayList<Function<class_1657, class_1799>>();

    private ArmorRendererRegistry() {
    }

    public static void register(CustomArmorRenderer renderer) {
        renderers.add(renderer);
    }

    public static CustomArmorRenderer getRenderer(class_1799 stack) {
        for (CustomArmorRenderer renderer : renderers) {
            if (!renderer.canRender(stack)) continue;
            return renderer;
        }
        return null;
    }

    public static void registerChestplateProvider(Function<class_1657, class_1799> provider) {
        chestplateProviders.add(provider);
    }

    public static class_1799 getChestplate(class_1657 player) {
        for (Function<class_1657, class_1799> provider : chestplateProviders) {
            class_10192 equippable;
            class_1799 stack = provider.apply(player);
            if (stack == null || stack.method_7960() || (equippable = (class_10192)stack.method_58694(class_9334.field_54196)).comp_3174() != class_1304.field_6174) continue;
            return stack;
        }
        return ((InventoryAccessor)player.method_31548()).getEquipment().method_66659(class_1304.field_6174);
    }
}

