//? if fabric {
/*package com.github.razorplay01.ismah.fabric.screen;

import com.github.razorplay01.ismah.client.ISMAHClient;
import com.github.razorplay01.ismah.client.config.ModConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
//? if >=1.20 {
import net.minecraft.client.gui.GuiGraphics;
//?} else {
//?}
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
//? if >=1.21.9 {
import net.minecraft.client.input.MouseButtonEvent;
//?}
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BlacklistConfigScreen extends Screen {
    private final Screen parent;
    private BlacklistListWidget list;
    private EditBox addField;

    public BlacklistConfigScreen(Screen parent) {
        super(Component.literal("ISMAH Configuration"));
        this.parent = parent;
    }

    @Override
    protected void init() {
        Button doneButton;
        Button addButton;
        // List widget for blacklisted armors
        this.list = new BlacklistListWidget(this.minecraft);
        this.addRenderableWidget(this.list);

        // Text field for adding new armor IDs
        this.addField = new EditBox(this.font, this.width / 2 - 100, this.height - 60, 150, 20, Component.literal("Add Armor ID"));
        this.addField.setMaxLength(128);
        this.addRenderableWidget(this.addField);

        //? if >=1.19.4 {
        addButton = Button.builder(Component.literal("Add"), button -> this.addEntry())
                .bounds(this.width / 2 + 55, this.height - 60, 45, 20).build();
        this.addRenderableWidget(addButton);

        doneButton = Button.builder(Component.literal("Done"), button -> this.onClose())
                .bounds(this.width / 2 - 100, this.height - 30, 200, 20).build();
        this.addRenderableWidget(doneButton);
        //?} else {
        /^addButton = new Button(this.width / 2 + 55, this.height - 60, 45, 20, Component.literal("Add"), button -> this.addEntry());
        this.addRenderableWidget(addButton);

        // Done button
        doneButton = new Button(this.width / 2 - 100, this.height - 30, 200, 20, Component.literal("Done"), button -> this.onClose());
        this.addRenderableWidget(doneButton);
        ^///?}
    }

    private void addEntry() {
        String id = this.addField.getValue().trim();
        if (!id.isEmpty()) {
            try {
                //? if >=1.21 {
                ResourceLocation.parse(id);
                //?} else {
                /^new ResourceLocation(id);
                 ^///?}
                ModConfig.addBlacklistedArmor(id);
                this.list.refreshEntries();
                this.addField.setValue("");
            } catch (Exception e) {
                this.addField.setValue("");
            }
        }
    }

    @Override
    public void onClose() {
        ModConfig.saveConfig();
        this.minecraft.setScreen(this.parent);
    }

    //? if >=1.20 {
    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        //?} else {
        /^public void render(PoseStack context, int mouseX, int mouseY, float delta) {
         ^///?}
        //? if <1.21 {
        /^this.renderBackground(context);
         ^///?}
        this.list.render(context, mouseX, mouseY, delta);

        //? if >=1.20 {
        context.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        //?} else {
        /^this.font.draw(context, this.title, this.width / 2, 20, 0xFFFFFF);
         ^///?}

        super.render(context, mouseX, mouseY, delta);
    }

    //? if <1.21.9 {
    /^public class BlacklistListWidget extends AbstractSelectionList<BlacklistListWidget.Entry> {
        public BlacklistListWidget(Minecraft client) {
            //? if >=1.21 {
            super(client, BlacklistConfigScreen.this.width, BlacklistConfigScreen.this.height - 95, 32, 25);
            //?} else {
            /^¹super(client, BlacklistConfigScreen.this.width, BlacklistConfigScreen.this.height - 95, 32, 25, 0);
     ¹^///?}
            this.refreshEntries();
        }

        public void refreshEntries() {
            this.clearEntries();
            for (String id : ModConfig.getBlacklistedArmors()) {
                this.addEntry(new Entry(id));
            }
        }

        //? if <1.21 {
        /^¹@Override
        public void updateNarration(NarrationElementOutput narrationElementOutput) {
            // []
        }
        ¹^///?}

        //? if >=1.21 {
        @Override
        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            // []
        }
        //?}

        public class Entry extends AbstractSelectionList.Entry<Entry> {
            private final String id;
            private final Button removeButton;

            public Entry(String id) {
                this.id = id;

                //? if >=1.19.4 {
                this.removeButton = Button.builder(Component.literal("Remove"), button -> {
                    ModConfig.removeBlacklistedArmor(this.id);
                    BlacklistListWidget.this.refreshEntries();
                }).bounds(0, 0, 60, 20).build();
                //?} else {
                /^¹this.removeButton = new Button(0, 0, 60, 20, Component.literal("Remove"), button -> {
                    ModConfig.removeBlacklistedArmor(this.id);
                    BlacklistListWidget.this.refreshEntries();
                });
                ¹^///?}
            }

            @Override
            //? if >=1.20 {
            public void render(GuiGraphics guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            //?} else {
            /^¹public void render(PoseStack guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
     ¹^///?}
                int textX = x + 5;
                int textY = y + (entryHeight - BlacklistConfigScreen.this.font.lineHeight) / 2 + 1;

                //? if >=1.20 {
                guiGraphics.drawString(BlacklistConfigScreen.this.font, this.id, textX, textY, 0xFFFFFF, true);
                //?} else {
                /^¹BlacklistConfigScreen.this.font.draw(guiGraphics ,this.id, textX, textY, 0xFFFFFF);
     ¹^///?}

                //? if >=1.19.4 {
                this.removeButton.setX(x + entryWidth - 65);
                this.removeButton.setY(y);
                //?} else {
                /^¹this.removeButton.x = x + entryWidth - 65;
                this.removeButton.y = y;
                ¹^///?}

                this.removeButton.render(guiGraphics, mouseX, mouseY, tickDelta);
            }

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                return this.removeButton.mouseClicked(mouseX, mouseY, button) || super.mouseClicked(mouseX, mouseY, button);
            }

            @Override
            public boolean mouseReleased(double mouseX, double mouseY, int button) {
                return this.removeButton.mouseReleased(mouseX, mouseY, button) || super.mouseReleased(mouseX, mouseY, button);
            }
        }
    }
    ^///?}

    //? if >= 1.21.9 {
    public class BlacklistListWidget extends AbstractSelectionList<BlacklistListWidget.Entry> {
        public BlacklistListWidget(Minecraft client) {
            super(client, BlacklistConfigScreen.this.width, BlacklistConfigScreen.this.height - 95, 32, 25);
            this.refreshEntries();
        }

        public void refreshEntries() {
            this.clearEntries();
            for (String id : ModConfig.getBlacklistedArmors()) {
                this.addEntry(new Entry(id));
            }
        }

        @Override
        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            // []
        }

        public class Entry extends AbstractSelectionList.Entry<Entry> {
            private final String id;
            private final Button removeButton;

            public Entry(String id) {
                this.id = id;

                this.removeButton = Button.builder(Component.literal("Remove"), button -> {
                    ModConfig.removeBlacklistedArmor(this.id);
                    BlacklistListWidget.this.refreshEntries();
                }).bounds(0, 0, 60, 20).build();
            }

            @Override
            public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                // DEBUG: Quad azul pequeño (mantén por ahora)
                guiGraphics.fill(getX(), getY(), getX() + 10, getY() + 10, 0xFF00FFFF);

                // Posición (mantenemos la tuya, que es buena)
                int textX = getContentX(); // 105
                int textY = getContentY() + ((getContentHeight() - BlacklistConfigScreen.this.font.lineHeight) / 2); // 42

                // TEST 1: Fondo semi-trans detrás del texto (gris oscuro) para forzar visibilidad
                int textWidth = BlacklistConfigScreen.this.font.width(this.id);
                int fontHeight = BlacklistConfigScreen.this.font.lineHeight;
                guiGraphics.fill(textX - 1, textY - 1, textX + textWidth + 1, textY + fontHeight, 0x80202020); // Gris semi-trans

                // TEST 2: Texto en NEGRO (fácil de ver) + SIN shadow
                guiGraphics.drawString(BlacklistConfigScreen.this.font, this.id, textX, textY, 0x000000, false); // Negro puro

                // TEST 3: Si quieres, agrega una línea roja horizontal debajo para ver si dibuja algo
                guiGraphics.fill(textX, textY + fontHeight, textX + textWidth, textY + fontHeight + 1, 0xFFFF0000); // Línea roja

                // Botón (igual)
                this.removeButton.setX(getX() + getWidth() - 65);
                this.removeButton.setY(getY());
                this.removeButton.render(guiGraphics, mouseX, mouseY, tickDelta);

                // Hover rojo (mantén)
                if (hovered) {
                    guiGraphics.fill(getContentX(), getContentY(), getContentRight(), getContentBottom(), 0x80FF0000);
                }
            }

            @Override
            public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
                return this.removeButton.mouseClicked(mouseButtonEvent, bl) || super.mouseClicked(mouseButtonEvent, bl);
            }

            @Override
            public boolean mouseReleased(MouseButtonEvent mouseButtonEvent) {
                return this.removeButton.mouseReleased(mouseButtonEvent) || super.mouseReleased(mouseButtonEvent);
            }
        }
    }
    //?}
}
*///?}