//? if neoforge {
package com.github.razorplay01.ismah.neoforge.mixin;

import com.github.razorplay01.ismah.neoforge.screen.BlacklistConfigScreen;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.SkinCustomizationScreen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(SkinCustomizationScreen.class)
public class SkinCustomizationScreenMixin extends Screen {
    protected SkinCustomizationScreenMixin(Component title) {
        super(title);
    }

    @Inject(method = "addOptions", at = @At("TAIL"))
    private void addBlacklistButton(CallbackInfo ci) {
        this.addRenderableWidget(Button.builder(Component.literal("ISMAH Config"), button ->
                this.minecraft.setScreen(new BlacklistConfigScreen(this))
        ).bounds(5, 5, 80, 20).build());
    }
}
//?}