/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.client.api;

import com.github.razorplay01.ismah.client.api.CustomArmorRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;

public class ArmorRendererRegistry {
    private static final List<CustomArmorRenderer> renderers = new ArrayList<CustomArmorRenderer>();
    private static final List<Function<Player, ItemStack>> chestplateProviders = new ArrayList<Function<Player, ItemStack>>();

    private ArmorRendererRegistry() {
    }

    public static void register(CustomArmorRenderer renderer) {
        renderers.add(renderer);
    }

    public static CustomArmorRenderer getRenderer(ItemStack stack) {
        for (CustomArmorRenderer renderer : renderers) {
            if (!renderer.canRender(stack)) continue;
            return renderer;
        }
        return null;
    }

    public static void registerChestplateProvider(Function<Player, ItemStack> provider) {
        chestplateProviders.add(provider);
    }

    public static ItemStack getChestplate(Player player) {
        for (Function<Player, ItemStack> provider : chestplateProviders) {
            ItemStack stack = provider.apply(player);
            if (stack == null || stack.isEmpty() || !(stack.getItem() instanceof ArmorItem)) continue;
            return stack;
        }
        return player.getInventory().getArmor(2);
    }
}

