/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.client.util;

import com.github.razorplay01.ismah.client.api.ArmorRendererRegistry;
import com.github.razorplay01.ismah.client.api.CustomArmorRenderer;
import com.github.razorplay01.ismah.client.config.ModConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.equipment.EquipmentModel;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimPattern;

public class RenderUtil {
    private RenderUtil() {
    }

    public static void renderArmor(EntityModel entityModel, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, HumanoidArm arm, boolean isSleeveVisible) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player.isInvisible()) {
            return;
        }
        ItemStack armor = player.getInventory().getArmor(2);
        if (armor.isEmpty() || armor.is(Items.AIR) || !(armor.getItem() instanceof ArmorItem)) {
            return;
        }
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)armor.getItem());
        if (ModConfig.isArmorBlacklisted(itemId)) {
            return;
        }
        Equippable equippable = (Equippable)armor.get(DataComponents.EQUIPPABLE);
        PlayerModel playerModel = (PlayerModel)entityModel;
        ModelPart armModel = arm == HumanoidArm.RIGHT ? playerModel.rightArm : playerModel.leftArm;
        armModel.resetPose();
        armModel.visible = true;
        playerModel.leftSleeve.visible = isSleeveVisible;
        playerModel.rightSleeve.visible = isSleeveVisible;
        playerModel.leftArm.zRot = -0.1f;
        playerModel.rightArm.zRot = 0.1f;
        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);
        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, arm, (HumanoidModel<HumanoidRenderState>)((HumanoidModel)entityModel));
        } else {
            HumanoidModel armorModel = new HumanoidModel(HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f).getRoot().bake(64, 32));
            playerModel.copyPropertiesTo((HumanoidModel)playerModel);
            ModelPart armorArm = arm == HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
            ModelPart playerArm = arm == HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
            armorArm.copyFrom(playerArm);
            armorArm.xRot = 0.0f;
            RenderUtil.renderEquipmentLayers(poseStack, buffer, armor, equippable, armorArm, combinedLight);
            RenderUtil.renderArmorTrim(poseStack, buffer, armor, equippable, armorArm, combinedLight);
            RenderUtil.renderGlintIfNeeded(poseStack, buffer, combinedLight, armor, armorArm);
        }
    }

    private static void renderEquipmentLayers(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, Equippable equippable, ModelPart armorArm, int light) {
        ResourceLocation modelId = (ResourceLocation)equippable.model().orElseThrow();
        List layers = Minecraft.getInstance().getEquipmentModels().get(modelId).getLayers(EquipmentModel.LayerType.HUMANOID);
        if (!layers.isEmpty()) {
            int dyeColor = chestplate.is(ItemTags.DYEABLE) ? DyedItemColor.getOrDefault((ItemStack)chestplate, (int)0) : 0;
            boolean hasFoil = chestplate.hasFoil();
            for (EquipmentModel.Layer layer : layers) {
                int color = RenderUtil.getColorForLayer(layer, dyeColor);
                if (color == 0) continue;
                ResourceLocation texture = layer.getTextureLocation(EquipmentModel.LayerType.HUMANOID);
                VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)vertexConsumers, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)texture), (boolean)hasFoil);
                armorArm.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
                hasFoil = false;
            }
        }
    }

    private static int getColorForLayer(EquipmentModel.Layer layer, int dyeColor) {
        Optional dyeable = layer.dyeable();
        if (dyeable.isPresent()) {
            int defaultColor = ((EquipmentModel.Dyeable)dyeable.get()).colorWhenUndyed().map(color -> 0xFF000000 | color).orElse(0);
            return dyeColor != 0 ? dyeColor : defaultColor;
        }
        return -1;
    }

    private static void renderArmorTrim(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, Equippable equippable, ModelPart armorArm, int light) {
        ArmorTrim trim = (ArmorTrim)chestplate.get(DataComponents.TRIM);
        if (trim != null) {
            ResourceLocation modelId = (ResourceLocation)equippable.model().orElseThrow();
            ResourceLocation trimTextureId = trim.getTexture(EquipmentModel.LayerType.HUMANOID, modelId);
            TextureAtlasSprite trimSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(Sheets.ARMOR_TRIMS_SHEET).apply(trimTextureId);
            VertexConsumer trimConsumer = trimSprite.wrap(vertexConsumers.getBuffer(Sheets.armorTrimsSheet((boolean)((TrimPattern)trim.pattern().value()).decal())));
            armorArm.render(poseStack, trimConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }

    private static void renderGlintIfNeeded(PoseStack matrices, MultiBufferSource vertexConsumers, int light, ItemStack armor, ModelPart armorArm) {
        if (armor.hasFoil()) {
            VertexConsumer glintConsumer = vertexConsumers.getBuffer(RenderType.entityGlint());
            armorArm.render(matrices, glintConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }
}

