/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.client.api;

import com.github.razorplay01.ismah.client.api.CustomArmorRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.item.AdventureModeCheck;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.trading.MerchantOffer;

public class ArmorRendererRegistry {
    private static final List<CustomArmorRenderer> renderers = new ArrayList<CustomArmorRenderer>();
    private static final List<Function<AdventureModeCheck, MerchantOffer>> chestplateProviders = new ArrayList<Function<AdventureModeCheck, MerchantOffer>>();

    private ArmorRendererRegistry() {
    }

    public static void register(CustomArmorRenderer renderer) {
        renderers.add(renderer);
    }

    public static CustomArmorRenderer getRenderer(MerchantOffer stack) {
        for (CustomArmorRenderer renderer : renderers) {
            if (!renderer.canRender(stack)) continue;
            return renderer;
        }
        return null;
    }

    public static void registerChestplateProvider(Function<AdventureModeCheck, MerchantOffer> provider) {
        chestplateProviders.add(provider);
    }

    public static MerchantOffer getChestplate(AdventureModeCheck player) {
        for (Function<AdventureModeCheck, MerchantOffer> provider : chestplateProviders) {
            MerchantOffer stack = provider.apply(player);
            if (stack == null || stack.isEmpty() || !(stack.getItem() instanceof CraftingRecipe)) continue;
            return stack;
        }
        return player.getInventory().getArmor(2);
    }
}

