/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.client.util;

import com.github.razorplay01.ismah.client.util.LeashRenderer;
import com.github.razorplay01.ismah.client.util.LeashStateAccess;
import com.github.razorplay01.ismah.common.mixin.PlayerModelAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.debug.BrainDebugRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HorseArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.ShowTradesToPlayer;
import net.minecraft.world.item.AdventureModeCheck;

public class LeashRenderLayer<T extends ShowTradesToPlayer, M extends MultiBufferSource<T>>
extends RenderLayer<T, M> {
    public LeashRenderLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(PoseStack poseStack, HorseArmorLayer multiBufferSource, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        AdventureModeCheck player;
        if (entity instanceof AdventureModeCheck && ((LeashStateAccess)(player = (AdventureModeCheck)entity)).getLeashState()) {
            ItemTransform model = (ItemTransform)this.getParentModel();
            if (player.getMainArm() == SetLookAndInteract.RIGHT) {
                BrainDebugRenderer leash = ((PlayerModelAccessor)model).isSlim() ? LeashRenderer.RIGHT_LEASH_SLIM : LeashRenderer.RIGHT_LEASH;
                LeashRenderer.renderArmLeash(poseStack, multiBufferSource, light, model.rightArm, leash);
            } else {
                BrainDebugRenderer leash = ((PlayerModelAccessor)model).isSlim() ? LeashRenderer.LEFT_LEASH_SLIM : LeashRenderer.LEFT_LEASH;
                LeashRenderer.renderArmLeash(poseStack, multiBufferSource, light, model.leftArm, leash);
            }
        }
    }
}

