/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.client.util;

import com.github.razorplay01.ismah.common.mixin.PlayerModelAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.debug.BrainDebugRenderer;
import net.minecraft.client.renderer.debug.ChunkDebugRenderer;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.debug.GameEventListenerRenderer;
import net.minecraft.client.renderer.debug.GameTestDebugRenderer;
import net.minecraft.client.renderer.debug.HeightMapRenderer;
import net.minecraft.client.renderer.debug.LightDebugRenderer;
import net.minecraft.client.renderer.entity.WardenRenderer;
import net.minecraft.client.renderer.entity.layers.HorseArmorLayer;
import net.minecraft.client.renderer.entity.layers.PandaHoldsItemLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.server.commands.ItemCommands;

public class LeashRenderer {
    private static final ItemCommands TEXTURE = new ItemCommands("textures/entity/lead_knot.png");
    public static final BrainDebugRenderer RIGHT_LEASH = LeashRenderer.buildModel("leads$right_leash", GameEventListenerRenderer.create().texOffs(0, 0).addBox(1.0f, -3.0f, -3.0f, 6.0f, 8.0f, 6.0f, new DebugRenderer(0.0f)));
    public static final BrainDebugRenderer RIGHT_LEASH_SLIM = LeashRenderer.buildModel("leads$right_leash_slim", GameEventListenerRenderer.create().texOffs(0, 0).addBox(2.0f, -3.0f, -3.0f, 5.0f, 8.0f, 6.0f, new DebugRenderer(0.0f)));
    public static final BrainDebugRenderer LEFT_LEASH = LeashRenderer.buildModel("leads$left_leash", GameEventListenerRenderer.create().texOffs(0, 0).addBox(3.0f, -3.0f, -3.0f, 6.0f, 8.0f, 6.0f, new DebugRenderer(0.0f)));
    public static final BrainDebugRenderer LEFT_LEASH_SLIM = LeashRenderer.buildModel("leads$left_leash", GameEventListenerRenderer.create().texOffs(0, 0).addBox(3.0f, -3.0f, -3.0f, 5.0f, 8.0f, 6.0f, new DebugRenderer(0.0f)));

    private LeashRenderer() {
    }

    public static BrainDebugRenderer buildModel(String name, GameEventListenerRenderer builder) {
        HeightMapRenderer modelData = new HeightMapRenderer();
        LightDebugRenderer modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild(name, builder, ChunkDebugRenderer.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        return GameTestDebugRenderer.create((HeightMapRenderer)modelData, (int)32, (int)32).bakeRoot();
    }

    public static void renderRightArmLeash(PoseStack matrices, HorseArmorLayer vertices, int light, ItemTransform<WardenRenderer> model) {
        BrainDebugRenderer leash = ((PlayerModelAccessor)model).isSlim() ? RIGHT_LEASH_SLIM : RIGHT_LEASH;
        LeashRenderer.renderArmLeash(matrices, vertices, light, model.rightArm, leash);
    }

    public static void renderLeftArmLeash(PoseStack matrices, HorseArmorLayer vertices, int light, ItemTransform<WardenRenderer> model) {
        BrainDebugRenderer leash = ((PlayerModelAccessor)model).isSlim() ? LEFT_LEASH_SLIM : LEFT_LEASH;
        LeashRenderer.renderArmLeash(matrices, vertices, light, model.leftArm, leash);
    }

    public static void renderArmLeash(PoseStack matrices, HorseArmorLayer vertices, int light, BrainDebugRenderer arm, BrainDebugRenderer leash) {
        leash.x = arm.x;
        leash.y = arm.y;
        leash.z = arm.z;
        leash.xRot = arm.xRot;
        leash.yRot = arm.yRot;
        leash.zRot = arm.zRot;
        leash.xScale = arm.xScale;
        leash.yScale = arm.yScale;
        leash.zScale = arm.zScale;
        leash.render(matrices, vertices.getBuffer(PandaHoldsItemLayer.entitySolid((ItemCommands)TEXTURE)), light, OverlayTexture.NO_OVERLAY);
    }
}

