/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.client.util;

import com.github.razorplay01.ismah.client.api.ArmorRendererRegistry;
import com.github.razorplay01.ismah.client.api.CustomArmorRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.renderer.SpriteCoordinateExpander;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.debug.BrainDebugRenderer;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.entity.WardenRenderer;
import net.minecraft.client.renderer.entity.layers.HorseArmorLayer;
import net.minecraft.client.renderer.entity.layers.PandaHoldsItemLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.ShowTradesToPlayer;
import net.minecraft.world.item.AdventureModeCheck;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.enchantment.BindingCurseEnchantment;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.BaseCommandBlock;

public class RenderUtil {
    private RenderUtil() {
    }

    public static void renderArmor(ItemTransform playerModel, PoseStack poseStack, HorseArmorLayer buffer, int combinedLight, WardenRenderer player, SetLookAndInteract arm) {
        if (player.isInvisible()) {
            return;
        }
        MerchantOffer armor = ArmorRendererRegistry.getChestplate((AdventureModeCheck)player);
        if (armor.isEmpty() || armor.is(BaseCommandBlock.AIR) || !(armor.getItem() instanceof CraftingRecipe)) {
            return;
        }
        BrainDebugRenderer armModel = arm == SetLookAndInteract.RIGHT ? playerModel.rightArm : playerModel.leftArm;
        armModel.resetPose();
        armModel.f_234493_ = true;
        playerModel.leftArm.zRot = -0.1f;
        playerModel.rightArm.zRot = 0.1f;
        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);
        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, arm, (SpriteCoordinateExpander<ShowTradesToPlayer>)playerModel);
        } else {
            SpriteCoordinateExpander armorModel = new SpriteCoordinateExpander(SpriteCoordinateExpander.createMesh((DebugRenderer)new DebugRenderer(1.0f), (float)0.0f).getRoot().bake(64, 32));
            playerModel.copyPropertiesTo((SpriteCoordinateExpander)playerModel);
            BrainDebugRenderer armorArm = arm == SetLookAndInteract.LEFT ? armorModel.leftArm : armorModel.rightArm;
            BrainDebugRenderer playerArm = arm == SetLookAndInteract.LEFT ? playerModel.leftArm : playerModel.rightArm;
            armorArm.copyFrom(playerArm);
            armorArm.xRot = 0.0f;
            RenderUtil.renderEquipmentLayers(poseStack, buffer, combinedLight, armor, armorArm);
            RenderUtil.renderGlintIfNeeded(poseStack, buffer, combinedLight, armor, armorArm);
        }
    }

    private static void renderEquipmentLayers(PoseStack matrices, HorseArmorLayer vertexConsumers, int light, MerchantOffer armor, BrainDebugRenderer armorArm) {
        CraftingRecipe armorItem = (CraftingRecipe)armor.getItem();
        if (armorItem instanceof BindingCurseEnchantment) {
            BindingCurseEnchantment dyeableArmorItem = (BindingCurseEnchantment)armorItem;
            int color = dyeableArmorItem.getColor(armor);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            RenderUtil.renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, r, g, b, null);
            RenderUtil.renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, 1.0f, 1.0f, 1.0f, "overlay");
        } else {
            RenderUtil.renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, 1.0f, 1.0f, 1.0f, null);
        }
    }

    private static void renderArmorLayer(PoseStack matrices, HorseArmorLayer vertexConsumers, int light, CraftingRecipe armorItem, BrainDebugRenderer armorPart, float r, float g, float b, String overlay) {
        ItemCommands armorTexture = RenderUtil.getArmorTexture(armorItem, overlay);
        AbstractButton vertexConsumer = vertexConsumers.getBuffer(PandaHoldsItemLayer.armorCutoutNoCull((ItemCommands)armorTexture));
        armorPart.render(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, r, g, b, 1.0f);
    }

    private static ItemCommands getArmorTexture(CraftingRecipe armorItem, String overlay) {
        String materialName = armorItem.getMaterial().getName();
        String namespace = "minecraft";
        String baseName = materialName;
        if (materialName.contains(":")) {
            String[] parts = materialName.split(":", 2);
            namespace = parts[0];
            baseName = parts[1];
        }
        String path = "textures/models/armor/" + baseName + "_layer_1" + (String)(overlay == null ? "" : "_" + overlay) + ".png";
        return new ItemCommands(namespace, path);
    }

    private static void renderGlintIfNeeded(PoseStack matrices, HorseArmorLayer vertexConsumers, int light, MerchantOffer armor, BrainDebugRenderer armorArm) {
        if (armor.hasFoil()) {
            AbstractButton glintConsumer = vertexConsumers.getBuffer(PandaHoldsItemLayer.entityGlint());
            armorArm.render(matrices, glintConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }
}

