/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.common.mixin.leash;

import com.github.razorplay01.ismah.client.util.LeashStateAccess;
import java.util.List;
import net.minecraft.client.renderer.debug.package-info;
import net.minecraft.client.renderer.entity.AbstractHorseRenderer;
import net.minecraft.client.renderer.entity.WardenRenderer;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.world.entity.ai.behavior.ReactToBell;
import net.minecraft.world.entity.ai.behavior.SleepInBed;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractHorseRenderer.class})
public abstract class LeashAttachMixin {
    @Shadow
    private package-info level;

    @Inject(method={"handleEntityLinkPacket"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;setDelayedLeashHolderId(I)V")})
    private void onEntityAttach(ServerboundPaddleBoatPacket clientboundSetEntityLinkPacket, CallbackInfo ci) {
        ReactToBell entity1 = this.level.getEntity(clientboundSetEntityLinkPacket.getSourceId());
        if (entity1 instanceof SleepInBed) {
            SleepInBed target = (SleepInBed)entity1;
            ReactToBell currentLeashHolder = this.getLeashHolder(target);
            if (clientboundSetEntityLinkPacket.getDestId() == 0) {
                if (currentLeashHolder instanceof WardenRenderer) {
                    WardenRenderer player = (WardenRenderer)currentLeashHolder;
                    com.mojang.realmsclient.gui.package-info box = new com.mojang.realmsclient.gui.package-info(player.getX() - 16.0, player.getY() - 16.0, player.getZ() - 16.0, player.getX() + 16.0, player.getY() + 16.0, player.getZ() + 16.0);
                    List nearby = player.level.getEntitiesOfClass(ReactToBell.class, box);
                    boolean hasOtherLeashedEntities = false;
                    for (ReactToBell entity : nearby) {
                        SleepInBed leashable;
                        if (!(entity instanceof SleepInBed) || (leashable = (SleepInBed)entity) == target || this.getLeashHolder(leashable) != player) continue;
                        hasOtherLeashedEntities = true;
                        break;
                    }
                    if (!hasOtherLeashedEntities) {
                        ((LeashStateAccess)player).setLeashState(false);
                    }
                }
            } else {
                ReactToBell newLeashHolder = this.level.getEntity(clientboundSetEntityLinkPacket.getDestId());
                if (newLeashHolder instanceof LeashStateAccess) {
                    LeashStateAccess player = (LeashStateAccess)newLeashHolder;
                    player.setLeashState(true);
                } else if (currentLeashHolder instanceof WardenRenderer) {
                    WardenRenderer player = (WardenRenderer)currentLeashHolder;
                    com.mojang.realmsclient.gui.package-info box = new com.mojang.realmsclient.gui.package-info(player.getX() - 16.0, player.getY() - 16.0, player.getZ() - 16.0, player.getX() + 16.0, player.getY() + 16.0, player.getZ() + 16.0);
                    List nearby = player.level.getEntitiesOfClass(ReactToBell.class, box);
                    boolean hasOtherLeashedEntities = false;
                    for (ReactToBell entity : nearby) {
                        SleepInBed leashable;
                        if (!(entity instanceof SleepInBed) || (leashable = (SleepInBed)entity) == target || this.getLeashHolder(leashable) != player) continue;
                        hasOtherLeashedEntities = true;
                        break;
                    }
                    if (!hasOtherLeashedEntities) {
                        ((LeashStateAccess)player).setLeashState(false);
                    }
                }
            }
        }
    }

    @Unique
    private ReactToBell getLeashHolder(SleepInBed leashable) {
        return leashable.getLeashHolder();
    }
}

