package com.github.razorplay01.ismah.client.util;

import com.github.razorplay01.ismah.client.api.ArmorRendererRegistry;
import com.github.razorplay01.ismah.client.api.CustomArmorRenderer;
import com.github.razorplay01.ismah.common.mixin.PlayerModelAccessor;
import org.spongepowered.asm.mixin.Unique;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;

public class RenderUtil {
    private RenderUtil() {
        // []
    }
    //? if >= 1.19 && <= 1.20.1 {
    public static void renderArmor(class_591 playerModel, class_4587 poseStack, class_4597 buffer, int combinedLight, class_742 player, net.minecraft.class_1306 arm) {
        if (player.method_5767()) return;
        class_1799 armor = ArmorRendererRegistry.getChestplate(player);
        if (armor.method_7960() || armor.method_31574(net.minecraft.class_1802.field_8162) || !(armor.method_7909() instanceof net.minecraft.class_1738))
            return;

        class_630 armModel = arm == net.minecraft.class_1306.field_6183 ? playerModel.field_3401 : playerModel.field_27433;
        armModel.method_41923();
        armModel.field_3665 = true;
        playerModel.field_27433.field_3674 = -0.1F;
        playerModel.field_3401.field_3674 = 0.1F;

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);

        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, arm, (net.minecraft.class_572<net.minecraft.class_1309>) playerModel);
        } else {
            net.minecraft.class_572 armorModel = new net.minecraft.class_572<>(
                    net.minecraft.class_572.method_32011(new net.minecraft.class_5605(1.0f), 0.0f).method_32111().method_32112(64, 32)
            );
            playerModel.method_2818(playerModel);

            class_630 armorArm = arm == net.minecraft.class_1306.field_6182 ? armorModel.field_27433 : armorModel.field_3401;
            class_630 playerArm = arm == net.minecraft.class_1306.field_6182 ? playerModel.field_27433 : playerModel.field_3401;
            armorArm.method_17138(playerArm);
            armorArm.field_3654 = 0.0F;

            renderEquipmentLayers(poseStack, buffer, combinedLight, armor, armorArm);
            //? if >= 1.20 && <= 1.20.1 {
            /*net.minecraft.world.item.armortrim.ArmorTrim.getTrim(net.minecraft.client.Minecraft.getInstance().level.registryAccess(), armor).ifPresent(
                    armorTrim -> renderArmorTrim(poseStack, buffer, combinedLight, armorTrim, (net.minecraft.world.item.ArmorItem) armor.getItem(), armorArm));*///?}
            renderGlintIfNeeded(poseStack, buffer, combinedLight, armor, armorArm);
        }
    }

    private static void renderEquipmentLayers(class_4587 matrices, class_4597 vertexConsumers,
                                       int light, class_1799 armor, class_630 armorArm) {
        net.minecraft.class_1738 armorItem = (net.minecraft.class_1738) armor.method_7909();

        if (armorItem instanceof net.minecraft.class_4057 dyeableArmorItem) {
            int color = dyeableArmorItem.method_7800(armor);
            float r = (color >> 16 & 255) / 255.0F;
            float g = (color >> 8 & 255) / 255.0F;
            float b = (color & 255) / 255.0F;
            renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, r, g, b, null);
            renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, 1.0F, 1.0F, 1.0F, "overlay");
        } else {
            renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, 1.0F, 1.0F, 1.0F, null);
        }
    }

    private static void renderArmorLayer(class_4587 matrices, class_4597 vertexConsumers, int light,
                                  net.minecraft.class_1738 armorItem, class_630 armorPart, float r, float g, float b, String overlay) {
        net.minecraft.class_2960 armorTexture = getArmorTexture(armorItem, overlay);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_25448(armorTexture));
        armorPart.method_22699(matrices, vertexConsumer, light, class_4608.field_21444, r, g, b, 1.0F);
    }

    private static net.minecraft.class_2960 getArmorTexture(net.minecraft.class_1738 armorItem, String overlay) {
        String path = "textures/models/armor/" + armorItem.method_7686().method_7694() + "_layer_1" +
                (overlay == null ? "" : "_" + overlay) + ".png";
        return new net.minecraft.class_2960(path);
    }

    //? if >= 1.20 && <= 1.20.1 {
    /*private static void renderArmorTrim(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, net.minecraft.world.item.armortrim.ArmorTrim armorTrim, net.minecraft.world.item.ArmorItem armorItem, ModelPart humanoidModel) {
        net.minecraft.client.renderer.texture.TextureAtlasSprite textureAtlasSprite = net.minecraft.client.Minecraft.getInstance().getTextureAtlas(net.minecraft.client.renderer.Sheets.ARMOR_TRIMS_SHEET)
                .apply(armorTrim.outerTexture(armorItem.getMaterial()));
        VertexConsumer vertexConsumer = textureAtlasSprite.wrap(multiBufferSource.getBuffer(net.minecraft.client.renderer.Sheets.armorTrimsSheet()));
        humanoidModel.render(poseStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY, 1.0F, 1.0F, 1.0F, 1.0F);
    }*///?}
    //?}

    //? if 1.21 || 1.21.1 {
    /*public static void renderArmor(net.minecraft.client.model.PlayerModel playerModel, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, net.minecraft.client.player.AbstractClientPlayer player, net.minecraft.world.entity.HumanoidArm arm) {
        if (player.isInvisible()) return;
        ItemStack armor = ArmorRendererRegistry.getChestplate(player);
        if (armor.isEmpty() || armor.is(net.minecraft.world.item.Items.AIR) || !(armor.getItem() instanceof net.minecraft.world.item.ArmorItem)) return;

        playerModel.attackTime = 0.0F;
        playerModel.crouching = false;
        playerModel.swimAmount = 0.0F;
        playerModel.setupAnim(player, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F);

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);

        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, arm, playerModel);
        } else {
            net.minecraft.client.model.HumanoidModel<net.minecraft.world.entity.LivingEntity> armorModel = new net.minecraft.client.model.HumanoidModel<>(
                    net.minecraft.client.model.HumanoidModel.createMesh(new net.minecraft.client.model.geom.builders.CubeDeformation(1.0f), 0.0f).getRoot().bake(64, 32)
            );
            playerModel.copyPropertiesTo(armorModel);
            ModelPart armorArm = arm == net.minecraft.world.entity.HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
            ModelPart playerArm = arm == net.minecraft.world.entity.HumanoidArm.LEFT ? ((net.minecraft.client.model.PlayerModel<?>) playerModel).leftArm : ((net.minecraft.client.model.PlayerModel<?>) playerModel).rightArm;
            armorArm.copyFrom(playerArm);
            armorArm.xRot = 0.0F;

            net.minecraft.world.item.ArmorItem armorItem = (net.minecraft.world.item.ArmorItem) armor.getItem();
            renderEquipmentLayers(poseStack, buffer, combinedLight, armor, armorItem, armorArm);
            renderArmorTrim(poseStack, buffer, combinedLight, armor, armorItem, armorArm);
            renderGlintIfNeeded(poseStack, buffer, combinedLight, armor, armorArm);
        }
    }

    private static void renderEquipmentLayers(PoseStack matrices, MultiBufferSource vertexConsumers,
                                              int light, ItemStack armor, net.minecraft.world.item.ArmorItem armorItem, ModelPart armorArm) {
        net.minecraft.world.item.ArmorMaterial armorMaterial = armorItem.getMaterial().value();
        if (!armorMaterial.layers().isEmpty()) {
            int dyeColor = armor.is(net.minecraft.tags.ItemTags.DYEABLE) ? net.minecraft.world.item.component.DyedItemColor.getOrDefault(armor, 0) : 0;
            boolean hasFoil = armor.hasFoil();

            for (net.minecraft.world.item.ArmorMaterial.Layer layer : armorMaterial.layers()) {
                int color = getColorForLayer(layer, dyeColor, armor);
                if (color != 0) {
                    net.minecraft.resources.ResourceLocation texture = layer.texture(false);
                    VertexConsumer vertexConsumer = net.minecraft.client.renderer.entity.ItemRenderer.getArmorFoilBuffer(vertexConsumers, RenderType.armorCutoutNoCull(texture), hasFoil);
                    armorArm.render(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
                    hasFoil = false;
                }
            }
        }
    }

    private static int getColorForLayer(net.minecraft.world.item.ArmorMaterial.Layer layer, int dyeColor, ItemStack armor) {
        var dyeable = layer.dyeable();
        if (dyeable) {
            int defaultColor = net.minecraft.util.FastColor.ARGB32.opaque(net.minecraft.world.item.component.DyedItemColor.getOrDefault(armor, -6265536));
            return dyeColor != 0 ? dyeColor : defaultColor;
        }
        return -1;
    }

    private static void renderArmorTrim(PoseStack matrices, MultiBufferSource vertexConsumers,
                                        int light, ItemStack armor, net.minecraft.world.item.ArmorItem armorItem, ModelPart armorArm) {
        net.minecraft.world.item.armortrim.ArmorTrim trim = armor.get(net.minecraft.core.component.DataComponents.TRIM);
        if (trim != null) {
            net.minecraft.client.renderer.texture.TextureAtlasSprite sprite = net.minecraft.client.Minecraft.getInstance().getTextureAtlas(net.minecraft.client.renderer.Sheets.ARMOR_TRIMS_SHEET)
                    .apply(trim.outerTexture(armorItem.getMaterial()));
            VertexConsumer trimVertexConsumer = sprite.wrap(
                    vertexConsumers.getBuffer(net.minecraft.client.renderer.Sheets.armorTrimsSheet((trim.pattern().value()).decal())));
            armorArm.render(matrices, trimVertexConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }
    *///?}


    //? if 1.21.2 || 1.21.3 {
    /*public static void renderArmor(net.minecraft.client.model.EntityModel entityModel, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, net.minecraft.world.entity.HumanoidArm arm, boolean isSleeveVisible) {
        net.minecraft.client.player.LocalPlayer player = net.minecraft.client.Minecraft.getInstance().player;
        if (player.isInvisible()) return;
        ItemStack armor = player.getInventory().getArmor(2);
        if (armor.isEmpty() || armor.is(net.minecraft.world.item.Items.AIR) || !(armor.getItem() instanceof net.minecraft.world.item.ArmorItem)) return;
        net.minecraft.world.item.equipment.Equippable equippable = armor.get(net.minecraft.core.component.DataComponents.EQUIPPABLE);

        net.minecraft.client.model.PlayerModel playerModel = (net.minecraft.client.model.PlayerModel) entityModel;

        ModelPart armModel = arm == net.minecraft.world.entity.HumanoidArm.RIGHT ? playerModel.rightArm : playerModel.leftArm;
        armModel.resetPose();
        armModel.visible = true;
        playerModel.leftSleeve.visible = isSleeveVisible;
        playerModel.rightSleeve.visible = isSleeveVisible;
        playerModel.leftArm.zRot = -0.1F;
        playerModel.rightArm.zRot = 0.1F;

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);

        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, arm, (net.minecraft.client.model.HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState>) entityModel);
        } else {
            net.minecraft.client.model.HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> armorModel = new net.minecraft.client.model.HumanoidModel<>(
                    net.minecraft.client.model.HumanoidModel.createMesh(new net.minecraft.client.model.geom.builders.CubeDeformation(1.0f), 0.0f).getRoot().bake(64, 32)
            );
            playerModel.copyPropertiesTo(playerModel);

            ModelPart armorArm = arm == net.minecraft.world.entity.HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
            ModelPart playerArm = arm == net.minecraft.world.entity.HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
            armorArm.copyFrom(playerArm);
            armorArm.xRot = 0.0F;

            renderEquipmentLayers(poseStack, buffer, armor, equippable, armorArm, combinedLight);
            renderArmorTrim(poseStack, buffer, armor, equippable, armorArm, combinedLight);
            renderGlintIfNeeded(poseStack, buffer, combinedLight, armor, armorArm);
        }
    }

    private static void renderEquipmentLayers(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, net.minecraft.world.item.equipment.Equippable equippable, ModelPart armorArm, int light) {
        net.minecraft.resources.ResourceLocation modelId = equippable.model().orElseThrow();
        java.util.List<net.minecraft.world.item.equipment.EquipmentModel.Layer> layers = net.minecraft.client.Minecraft.getInstance().getEquipmentModels().get(modelId).getLayers(net.minecraft.world.item.equipment.EquipmentModel.LayerType.HUMANOID);

        if (!layers.isEmpty()) {
            int dyeColor = chestplate.is(net.minecraft.tags.ItemTags.DYEABLE) ? net.minecraft.world.item.component.DyedItemColor.getOrDefault(chestplate, 0) : 0;
            boolean hasFoil = chestplate.hasFoil();

            for (net.minecraft.world.item.equipment.EquipmentModel.Layer layer : layers) {
                int color = getColorForLayer(layer, dyeColor);
                if (color != 0) {
                    net.minecraft.resources.ResourceLocation texture = layer.getTextureLocation(net.minecraft.world.item.equipment.EquipmentModel.LayerType.HUMANOID);
                    VertexConsumer vertexConsumer = net.minecraft.client.renderer.entity.ItemRenderer.getArmorFoilBuffer(vertexConsumers, RenderType.armorCutoutNoCull(texture), hasFoil);
                    armorArm.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
                    hasFoil = false;
                }
            }
        }
    }

    private static int getColorForLayer(net.minecraft.world.item.equipment.EquipmentModel.Layer layer, int dyeColor) {
        var dyeable = layer.dyeable();
        if (dyeable.isPresent()) {
            int defaultColor = dyeable.get().colorWhenUndyed().map(color -> 0xFF000000 | color).orElse(0);
            return dyeColor != 0 ? dyeColor : defaultColor;
        }
        return -1;
    }

    private static void renderArmorTrim(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, net.minecraft.world.item.equipment.Equippable equippable, ModelPart armorArm, int light) {
        net.minecraft.world.item.equipment.trim.ArmorTrim trim = chestplate.get(net.minecraft.core.component.DataComponents.TRIM);
        if (trim != null) {
            net.minecraft.resources.ResourceLocation modelId = equippable.model().orElseThrow();
            net.minecraft.resources.ResourceLocation trimTextureId = trim.getTexture(net.minecraft.world.item.equipment.EquipmentModel.LayerType.HUMANOID, modelId);
            net.minecraft.client.renderer.texture.TextureAtlasSprite trimSprite = net.minecraft.client.Minecraft.getInstance().getTextureAtlas(net.minecraft.client.renderer.Sheets.ARMOR_TRIMS_SHEET).apply(trimTextureId);
            VertexConsumer trimConsumer = trimSprite.wrap(vertexConsumers.getBuffer(net.minecraft.client.renderer.Sheets.armorTrimsSheet(trim.pattern().value().decal())));
            armorArm.render(poseStack, trimConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }
    *///?}

    //? if >= 1.21.5 {
    /*public static void renderArmor(EntityModel entityModel, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, HumanoidArm humanoidArm, boolean isSleeveVisible) {
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack armor = ArmorRendererRegistry.getChestplate(player);
        if (armor.isEmpty()) return;

        PlayerModel playerModel = (PlayerModel) entityModel;

        ModelPart armModel = humanoidArm == HumanoidArm.RIGHT ? playerModel.rightArm : playerModel.leftArm;
        armModel.resetPose();
        armModel.visible = true;
        playerModel.leftSleeve.visible = isSleeveVisible;
        playerModel.rightSleeve.visible = isSleeveVisible;
        playerModel.leftArm.zRot = -0.1F;
        playerModel.rightArm.zRot = 0.1F;

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);
        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, humanoidArm, (HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState>) entityModel);
        } else {
            net.minecraft.world.item.equipment.Equippable equippable = armor.get(net.minecraft.core.component.DataComponents.EQUIPPABLE);
            if (equippable != null && equippable.assetId().isPresent() && equippable.slot() == EquipmentSlot.CHEST) {
                renderEquipment(poseStack, buffer, player, humanoidArm, combinedLight, armor);
            }
        }
    }

    @Unique
    private static void renderEquipment(PoseStack poseStack, MultiBufferSource vertexConsumers, LocalPlayer player, HumanoidArm arm, int light, ItemStack chestplate) {
        net.minecraft.world.item.equipment.Equippable equippable = chestplate.get(net.minecraft.core.component.DataComponents.EQUIPPABLE);
        ModelPart armorArm = setupArmorModel(player, arm);
        renderEquipmentLayers(poseStack, vertexConsumers, chestplate, equippable, armorArm, light);
        renderTrim(poseStack, vertexConsumers, chestplate, equippable, armorArm, light);
        renderGlintIfNeeded(poseStack, vertexConsumers, light, chestplate, armorArm);
    }

    @Unique
    private static ModelPart setupArmorModel(LocalPlayer player, HumanoidArm arm) {
        PlayerRenderer playerRenderer = (PlayerRenderer) Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(player);
        PlayerModel playerModel = playerRenderer.getModel();

        HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> armorModel = new HumanoidModel<>(
                HumanoidModel.createMesh(new CubeDeformation(1.0f), 0.0f).getRoot().bake(64, 32)
        );

        ModelPart armorArm = arm == HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
        ModelPart playerArm = arm == HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
        armorArm.copyFrom(playerArm);

        return armorArm;
    }

    @Unique
    private static void renderEquipmentLayers(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, net.minecraft.world.item.equipment.Equippable equippable, ModelPart armorArm, int light) {
        ResourceKey<net.minecraft.world.item.equipment.EquipmentAsset> assetId = equippable.assetId().orElseThrow();
        List<net.minecraft.client.resources.model.EquipmentClientInfo.Layer> layers = ((com.github.razorplay01.ismah.common.mixin.EntityRenderDispatcherAccesor) Minecraft.getInstance().getEntityRenderDispatcher())
                .getEquipmentAssetManager()
                .get(assetId)
                .getLayers(net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID);

        if (!layers.isEmpty()) {
            int dyeColor = chestplate.is(ItemTags.DYEABLE) ? net.minecraft.world.item.component.DyedItemColor.getOrDefault(chestplate, 0) : 0;
            boolean hasFoil = chestplate.hasFoil();

            for (net.minecraft.client.resources.model.EquipmentClientInfo.Layer layer : layers) {
                int color = getColorForLayer(layer, dyeColor);
                if (color != 0) {
                    ResourceLocation texture = layer.getTextureLocation(net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID);
                    VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer(vertexConsumers, RenderType.armorCutoutNoCull(texture), hasFoil);
                    armorArm.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
                    hasFoil = false;
                }
            }
        }
    }

    @Unique
    private static int getColorForLayer(net.minecraft.client.resources.model.EquipmentClientInfo.Layer layer, int dyeColor) {
        var dyeable = layer.dyeable();
        if (dyeable.isPresent()) {
            int defaultColor = dyeable.get().colorWhenUndyed().map(color -> 0xFF000000 | color).orElse(0);
            return dyeColor != 0 ? dyeColor : defaultColor;
        }
        return -1;
    }

    @Unique
    private static void renderTrim(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, net.minecraft.world.item.equipment.Equippable equippable, ModelPart armorArm, int light) {
        net.minecraft.world.item.equipment.trim.ArmorTrim trim = chestplate.get(net.minecraft.core.component.DataComponents.TRIM);
        if (trim != null) {
            ResourceKey<net.minecraft.world.item.equipment.EquipmentAsset> assetId = equippable.assetId().orElseThrow();

            ResourceLocation patternAssetId = trim.pattern().value().assetId();
            String materialSuffix = getColorPaletteSuffix(trim.material(), assetId);
            ResourceLocation trimTextureId = patternAssetId.withPath(p -> "trims/entity/" + net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID.getSerializedName() + "/" + p + "_" + materialSuffix);

            TextureAtlasSprite trimSprite = Minecraft.getInstance().getTextureAtlas(Sheets.ARMOR_TRIMS_SHEET).apply(trimTextureId);
            VertexConsumer trimConsumer = trimSprite.wrap(vertexConsumers.getBuffer(Sheets.armorTrimsSheet(trim.pattern().value().decal())));
            armorArm.render(poseStack, trimConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }

    @Unique
    private static String getColorPaletteSuffix(Holder<net.minecraft.world.item.equipment.trim.TrimMaterial> trimMaterial, ResourceKey<net.minecraft.world.item.equipment.EquipmentAsset> equipmentAsset) {
        net.minecraft.world.item.equipment.trim.MaterialAssetGroup assets = trimMaterial.value().assets();
        net.minecraft.world.item.equipment.trim.MaterialAssetGroup.AssetInfo assetInfo = assets.assetId(equipmentAsset);
        return assetInfo.suffix();
    }
    *///?}

    private static void renderGlintIfNeeded(class_4587 matrices, class_4597 vertexConsumers,
                                            int light, class_1799 armor, class_630 armorArm) {
        if (armor.method_7958()) {
            class_4588 glintConsumer = vertexConsumers.getBuffer(class_1921.method_23591());
            armorArm.method_22698(matrices, glintConsumer, light, class_4608.field_21444);
        }
    }


    //? if 1.21.4 {
    /*public static void renderArmor(EntityModel entityModel, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, HumanoidArm humanoidArm, boolean isSleeveVisible) {
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack armor = ArmorRendererRegistry.getChestplate(player);
        if (armor.isEmpty()) return;

        PlayerModel playerModel = (PlayerModel) entityModel;

        ModelPart armModel = humanoidArm == HumanoidArm.RIGHT ? playerModel.rightArm : playerModel.leftArm;
        armModel.resetPose();
        armModel.visible = true;
        playerModel.leftSleeve.visible = isSleeveVisible;
        playerModel.rightSleeve.visible = isSleeveVisible;
        playerModel.leftArm.zRot = -0.1F;
        playerModel.rightArm.zRot = 0.1F;

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);
        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, humanoidArm, (HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState>) entityModel);
        } else {
            net.minecraft.world.item.equipment.Equippable equippable = armor.get(net.minecraft.core.component.DataComponents.EQUIPPABLE);
            if (equippable != null && equippable.assetId().isPresent() && equippable.slot() == EquipmentSlot.CHEST) {
                renderEquipment(poseStack, buffer, player, humanoidArm, combinedLight, armor);
            }
        }
    }

    @Unique
    private static void renderEquipment(PoseStack poseStack, MultiBufferSource vertexConsumers, LocalPlayer player, HumanoidArm arm, int light, ItemStack chestplate) {
        net.minecraft.world.item.equipment.Equippable equippable = chestplate.get(net.minecraft.core.component.DataComponents.EQUIPPABLE);
        ModelPart armorArm = setupArmorModel(player, arm);
        renderEquipmentLayers(poseStack, vertexConsumers, chestplate, equippable, armorArm, light);
        renderTrim(poseStack, vertexConsumers, chestplate, armorArm, light);
        renderGlintIfNeeded(poseStack, vertexConsumers, light, chestplate, armorArm);
    }

    @Unique
    private static ModelPart setupArmorModel(LocalPlayer player, HumanoidArm arm) {
        PlayerRenderer playerRenderer = (PlayerRenderer) Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(player);
        PlayerModel playerModel = playerRenderer.getModel();

        HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> armorModel = new HumanoidModel<>(
                HumanoidModel.createMesh(new CubeDeformation(1.0f), 0.0f).getRoot().bake(64, 32)
        );

        ModelPart armorArm = arm == HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
        ModelPart playerArm = arm == HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
        armorArm.copyFrom(playerArm);

        return armorArm;
    }

    @Unique
    private static void renderEquipmentLayers(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, net.minecraft.world.item.equipment.Equippable equippable, ModelPart armorArm, int light) {
        ResourceKey<net.minecraft.world.item.equipment.EquipmentAsset> assetId = equippable.assetId().orElseThrow();
        List<net.minecraft.client.resources.model.EquipmentClientInfo.Layer> layers =
                ((com.github.razorplay01.ismah.common.mixin.EntityRenderDispatcherAccesor) Minecraft.getInstance().getEntityRenderDispatcher())
                .getEquipmentAssetManager()
                .get(assetId)
                .getLayers(net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID);

        if (!layers.isEmpty()) {
            int dyeColor = chestplate.is(ItemTags.DYEABLE) ? net.minecraft.world.item.component.DyedItemColor.getOrDefault(chestplate, 0) : 0;
            boolean hasFoil = chestplate.hasFoil();

            for (net.minecraft.client.resources.model.EquipmentClientInfo.Layer layer : layers) {
                int color = getColorForLayer(layer, dyeColor);
                if (color != 0) {
                    ResourceLocation texture = layer.getTextureLocation(net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID);
                    VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer(vertexConsumers, RenderType.armorCutoutNoCull(texture), hasFoil);
                    armorArm.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
                    hasFoil = false;
                }
            }
        }
    }

    @Unique
    private static int getColorForLayer(net.minecraft.client.resources.model.EquipmentClientInfo.Layer layer, int dyeColor) {
        var dyeable = layer.dyeable();
        if (dyeable.isPresent()) {
            int defaultColor = dyeable.get().colorWhenUndyed().map(color -> 0xFF000000 | color).orElse(0);
            return dyeColor != 0 ? dyeColor : defaultColor;
        }
        return -1;
    }

    private static void renderTrim(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, ModelPart armorArm, int light) {
        net.minecraft.world.item.equipment.trim.ArmorTrim trim = chestplate.get(net.minecraft.core.component.DataComponents.TRIM);
        if (trim != null) {
            net.minecraft.resources.ResourceLocation trimTextureId = trim.pattern().value().assetId();
            net.minecraft.client.renderer.texture.TextureAtlasSprite trimSprite = net.minecraft.client.Minecraft.getInstance().getTextureAtlas(net.minecraft.client.renderer.Sheets.ARMOR_TRIMS_SHEET).apply(trimTextureId);
            VertexConsumer trimConsumer = trimSprite.wrap(vertexConsumers.getBuffer(net.minecraft.client.renderer.Sheets.armorTrimsSheet(trim.pattern().value().decal())));
            armorArm.render(poseStack, trimConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }
    *///?}
}
