/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.client.util;

import com.github.razorplay01.ismah.client.api.ArmorRendererRegistry;
import com.github.razorplay01.ismah.client.api.CustomArmorRenderer;
import com.github.razorplay01.ismah.client.config.ModConfig;
import com.github.razorplay01.ismah.common.mixin.EntityRenderDispatcherAccesor;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10034;
import net.minecraft.class_1007;
import net.minecraft.class_10186;
import net.minecraft.class_10192;
import net.minecraft.class_10394;
import net.minecraft.class_1058;
import net.minecraft.class_10714;
import net.minecraft.class_11659;
import net.minecraft.class_11785;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5321;
import net.minecraft.class_5605;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Unique;

public class RenderUtil {
    private RenderUtil() {
    }

    public static void renderArmor(class_583 entityModel, class_4587 poseStack, class_11659 submitNodeCollector, int combinedLight, class_1306 humanoidArm, boolean isSleeveVisible) {
        class_746 player = class_310.method_1551().field_1724;
        class_1799 armor = ArmorRendererRegistry.getChestplate((class_1657)player);
        if (armor.method_7960()) {
            return;
        }
        class_2960 itemId = class_7923.field_41178.method_10221((Object)armor.method_7909());
        if (ModConfig.isArmorBlacklisted(itemId)) {
            return;
        }
        class_591 playerModel = (class_591)entityModel;
        class_630 armModel = humanoidArm == class_1306.field_6183 ? playerModel.field_3401 : playerModel.field_27433;
        armModel.method_41923();
        armModel.field_3665 = true;
        playerModel.field_3484.field_3665 = isSleeveVisible;
        playerModel.field_3486.field_3665 = isSleeveVisible;
        playerModel.field_27433.field_3674 = -0.1f;
        playerModel.field_3401.field_3674 = 0.1f;
        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);
        if (customRenderer != null) {
            customRenderer.render(poseStack, submitNodeCollector, combinedLight, armor, humanoidArm, (class_572<class_10034>)((class_572)entityModel));
        } else {
            class_10192 equippable = (class_10192)armor.method_58694(class_9334.field_54196);
            if (equippable != null && equippable.comp_3176().isPresent() && equippable.comp_3174() == class_1304.field_6174) {
                RenderUtil.renderEquipment(poseStack, submitNodeCollector, player, humanoidArm, combinedLight, armor);
            }
        }
    }

    @Unique
    private static void renderEquipment(class_4587 poseStack, class_11659 submitNodeCollector, class_746 player, class_1306 arm, int light, class_1799 chestplate) {
        class_10192 equippable = (class_10192)chestplate.method_58694(class_9334.field_54196);
        class_630 armorArm = RenderUtil.setupArmorModel(player, arm);
        RenderUtil.renderEquipmentLayers(poseStack, submitNodeCollector, chestplate, equippable, armorArm, light);
        RenderUtil.renderTrim(poseStack, (class_11785)submitNodeCollector, chestplate, equippable, armorArm, light);
        RenderUtil.renderGlintIfNeeded(poseStack, submitNodeCollector, light, chestplate, armorArm);
    }

    @Unique
    private static class_630 setupArmorModel(class_746 player, class_1306 arm) {
        class_1007 playerRenderer = (class_1007)class_310.method_1551().method_1561().method_3953((class_1297)player);
        class_591 playerModel = (class_591)playerRenderer.method_4038();
        class_572 armorModel = new class_572(class_572.method_32011((class_5605)new class_5605(1.0f), (float)0.0f).method_32111().method_32112(64, 32));
        class_630 armorArm = arm == class_1306.field_6182 ? armorModel.field_27433 : armorModel.field_3401;
        class_630 playerArm = arm == class_1306.field_6182 ? playerModel.field_27433 : playerModel.field_3401;
        armorArm.method_32085(playerArm.method_32084());
        return armorArm;
    }

    @Unique
    private static void renderEquipmentLayers(class_4587 poseStack, class_11659 ordered, class_1799 chestplate, class_10192 equippable, class_630 armorArm, int light) {
        class_5321 assetId = (class_5321)equippable.comp_3176().orElseThrow();
        List layers = ((EntityRenderDispatcherAccesor)class_310.method_1551().method_1561()).getEquipmentAssetManager().method_64087(assetId).method_63996(class_10186.class_10190.field_54125);
        if (!layers.isEmpty()) {
            int dyeColor = chestplate.method_31573(class_3489.field_48803) ? class_9282.method_57470((class_1799)chestplate, (int)0) : 0;
            for (class_10186.class_10189 layer : layers) {
                int color = RenderUtil.getColorForLayer(layer, dyeColor);
                if (color == 0) continue;
                class_2960 texture = layer.method_64007(class_10186.class_10190.field_54125);
                class_1921 renderType = class_1921.method_25448((class_2960)texture);
                int packedColor = color & 0xFFFFFF | 0xFF000000;
                ordered.method_73494(armorArm, poseStack, renderType, light, class_4608.field_21444, null, false, false, packedColor, null, 0);
            }
        }
    }

    @Unique
    private static int getColorForLayer(class_10186.class_10189 layer, int dyeColor) {
        Optional dyeable = layer.comp_3172();
        if (dyeable.isPresent()) {
            int defaultColor = ((class_10186.class_10188)dyeable.get()).comp_3170().map(color -> 0xFF000000 | color).orElse(0);
            return dyeColor != 0 ? dyeColor | 0xFF000000 : defaultColor;
        }
        return -1;
    }

    @Unique
    private static void renderTrim(class_4587 poseStack, class_11785 ordered, class_1799 chestplate, class_10192 equippable, class_630 armorArm, int light) {
        class_8053 trim = (class_8053)chestplate.method_58694(class_9334.field_49607);
        if (trim != null) {
            class_5321 assetId = (class_5321)equippable.comp_3176().orElseThrow();
            class_2960 patternAssetId = ((class_8056)trim.comp_3180().comp_349()).comp_1213();
            String materialSuffix = RenderUtil.getColorPaletteSuffix((class_6880<class_8054>)trim.comp_3179(), (class_5321<class_10394>)assetId);
            class_2960 trimTextureId = patternAssetId.method_45134(p -> "trims/entity/" + class_10186.class_10190.field_54125.method_15434() + "/" + p + "_" + materialSuffix);
            class_4730 trimMaterial = new class_4730(class_4722.field_42071, trimTextureId);
            class_1058 trimSprite = class_310.method_1551().method_72703().method_73030(trimMaterial);
            class_1921 trimRenderType = class_4722.method_48480((boolean)((class_8056)trim.comp_3180().comp_349()).comp_1905());
            ordered.method_73494(armorArm, poseStack, trimRenderType, light, class_4608.field_21444, trimSprite, false, false, -1, null, 0);
        }
    }

    @Unique
    private static String getColorPaletteSuffix(class_6880<class_8054> trimMaterial, class_5321<class_10394> equipmentAsset) {
        class_10714 assets = ((class_8054)trimMaterial.comp_349()).comp_3606();
        class_10714.class_10715 assetInfo = assets.method_67227(equipmentAsset);
        return assetInfo.comp_3605();
    }

    @Unique
    private static void renderGlintIfNeeded(class_4587 poseStack, class_11659 ordered, int light, class_1799 armor, class_630 armorArm) {
        if (armor.method_7958()) {
            ordered.method_73491(armorArm, poseStack, class_1921.method_27949(), light, class_4608.field_21444, null);
        }
    }
}

