/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.client.util;

import com.github.razorplay01.ismah.common.mixin.PlayerModelAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class LeashRenderer {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"textures/entity/lead_knot.png");
    public static final ModelPart RIGHT_LEASH = LeashRenderer.buildModel("leads$right_leash", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, -3.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)));
    public static final ModelPart RIGHT_LEASH_SLIM = LeashRenderer.buildModel("leads$right_leash_slim", CubeListBuilder.create().texOffs(0, 0).addBox(2.0f, -3.0f, -3.0f, 5.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)));
    public static final ModelPart LEFT_LEASH = LeashRenderer.buildModel("leads$left_leash", CubeListBuilder.create().texOffs(0, 0).addBox(3.0f, -3.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)));
    public static final ModelPart LEFT_LEASH_SLIM = LeashRenderer.buildModel("leads$left_leash", CubeListBuilder.create().texOffs(0, 0).addBox(3.0f, -3.0f, -3.0f, 5.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)));

    private LeashRenderer() {
    }

    public static ModelPart buildModel(String name, CubeListBuilder builder) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild(name, builder, PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)32).bakeRoot();
    }

    public static void renderRightArmLeash(PoseStack matrices, SubmitNodeCollector submitNodeCollector, int light, HumanoidModel<HumanoidRenderState> model) {
        ModelPart leash = ((PlayerModelAccessor)model).isSlim() ? RIGHT_LEASH_SLIM : RIGHT_LEASH;
        LeashRenderer.renderArmLeash(matrices, submitNodeCollector, light, model.rightArm, leash);
    }

    public static void renderLeftArmLeash(PoseStack matrices, SubmitNodeCollector submitNodeCollector, int light, HumanoidModel<HumanoidRenderState> model) {
        ModelPart leash = ((PlayerModelAccessor)model).isSlim() ? LEFT_LEASH_SLIM : LEFT_LEASH;
        LeashRenderer.renderArmLeash(matrices, submitNodeCollector, light, model.leftArm, leash);
    }

    public static void renderArmLeash(PoseStack matrices, SubmitNodeCollector submitNodeCollector, int light, ModelPart arm, ModelPart leash) {
        leash.x = arm.x;
        leash.y = arm.y;
        leash.z = arm.z;
        leash.xRot = arm.xRot;
        leash.yRot = arm.yRot;
        leash.zRot = arm.zRot;
        leash.xScale = arm.xScale;
        leash.yScale = arm.yScale;
        leash.zScale = arm.zScale;
        submitNodeCollector.submitModelPart(leash, matrices, RenderType.entitySolid((ResourceLocation)TEXTURE), light, OverlayTexture.NO_OVERLAY, null, false, false, -1, null, 0);
    }
}

