package com.github.razorplay01.ismah.client.api;

import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_918;

/**
 * Interface for custom armor renderers in first-person view.
 * Mod developers can implement this interface to define how their armor items should be rendered
 * on the player's arm in first-person perspective when registered with {@link ArmorRendererRegistry}.
 */
public interface CustomArmorRenderer {
    /**
     * Determines whether this renderer can handle the given armor ItemStack.
     * This method is called to check if the renderer should be used for a specific item.
     *
     * @param stack The ItemStack of the equipped armor.
     * @return {@code true} if this renderer should handle the ItemStack, {@code false} otherwise.
     */
    boolean canRender(class_1799 stack);

    //? if >= 1.19 && <= 1.20.1 {
    /*void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, ItemStack stack, HumanoidArm arm, HumanoidModel<net.minecraft.world.entity.LivingEntity> playerModel);

    default void renderArmor(PoseStack poseStack, MultiBufferSource bufferSource, int light, ItemStack stack, HumanoidArm arm, HumanoidModel<net.minecraft.world.entity.LivingEntity> playerModel, HumanoidModel<net.minecraft.world.entity.LivingEntity> armorModel, ResourceLocation texture) {
        ModelPart armorArm = arm == HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
        ModelPart playerArm = arm == HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
        armorArm.copyFrom(playerArm);

        VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer(bufferSource, RenderType.armorCutoutNoCull(texture), stack.hasFoil(), true);
        armorArm.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
    }
    *///?}

    //? if 1.21 || 1.21.1 {
    void render(class_4587 poseStack, class_4597 bufferSource, int light, class_1799 stack, class_1306 arm, class_572<net.minecraft.class_1309> playerModel);

    default void renderArmor(class_4587 poseStack, class_4597 bufferSource, int light, class_1799 stack, class_1306 arm, class_572<net.minecraft.class_1309> playerModel, class_572<net.minecraft.class_1309> armorModel, class_2960 texture) {
        class_630 armorArm = arm == class_1306.field_6182 ? armorModel.field_27433 : armorModel.field_3401;
        class_630 playerArm = arm == class_1306.field_6182 ? playerModel.field_27433 : playerModel.field_3401;
        armorArm.method_17138(playerArm);

        class_4588 vertexConsumer = class_918.method_27952(bufferSource, class_1921.method_25448(texture), stack.method_7958());
        armorArm.method_22698(poseStack, vertexConsumer, light, class_4608.field_21444);
    }
    //?}

    //? if 1.21.2 || 1.21.3 || 1.21.4 {
    /*void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, ItemStack stack, HumanoidArm arm, HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> playerModel);

    default void renderArmor(PoseStack poseStack, MultiBufferSource bufferSource, int light, ItemStack stack, HumanoidArm arm, HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> playerModel, HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> armorModel, ResourceLocation texture) {
        ModelPart armorArm = arm == HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
        ModelPart playerArm = arm == HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
        armorArm.copyFrom(playerArm);

        VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer(bufferSource, RenderType.armorCutoutNoCull(texture), stack.hasFoil());
        armorArm.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
    }
    *///?}

    //? if >= 1.21.5 {
    /*void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, ItemStack stack, HumanoidArm arm, HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> playerModel);

    default void renderArmor(PoseStack poseStack, MultiBufferSource bufferSource, int light, ItemStack stack, HumanoidArm arm, HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> playerModel, HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> armorModel, ResourceLocation texture) {
        ModelPart armorArm = arm == HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
        ModelPart playerArm = arm == HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
        armorArm.copyFrom(playerArm);

        VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer(bufferSource, RenderType.armorCutoutNoCull(texture), stack.hasFoil());
        armorArm.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
    }
    *///?}
}