package com.github.razorplay01.ismah.client.util;

import Z;
import com.github.razorplay01.ismah.client.api.ArmorRendererRegistry;
import com.github.razorplay01.ismah.client.api.CustomArmorRenderer;
import com.github.razorplay01.ismah.common.mixin.PlayerModelAccessor;
import org.spongepowered.asm.mixin.Unique;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_630;

public class RenderUtil {
    private RenderUtil() {
        // []
    }
    //? if >= 1.19 && <= 1.20.1 {
    /*public static void renderArmor(PlayerModel playerModel, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player, net.minecraft.world.entity.HumanoidArm arm) {
        if (player.isInvisible()) return;
        ItemStack armor = ArmorRendererRegistry.getChestplate(player);
        if (armor.isEmpty() || armor.is(net.minecraft.world.item.Items.AIR) || !(armor.getItem() instanceof net.minecraft.world.item.ArmorItem))
            return;

        ModelPart armModel = arm == net.minecraft.world.entity.HumanoidArm.RIGHT ? playerModel.rightArm : playerModel.leftArm;
        armModel.resetPose();
        armModel.visible = true;
        playerModel.leftArm.zRot = -0.1F;
        playerModel.rightArm.zRot = 0.1F;

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);

        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, arm, (net.minecraft.client.model.HumanoidModel<net.minecraft.world.entity.LivingEntity>) playerModel);
        } else {
            net.minecraft.client.model.HumanoidModel armorModel = new net.minecraft.client.model.HumanoidModel<>(
                    net.minecraft.client.model.HumanoidModel.createMesh(new net.minecraft.client.model.geom.builders.CubeDeformation(1.0f), 0.0f).getRoot().bake(64, 32)
            );
            playerModel.copyPropertiesTo(playerModel);

            ModelPart armorArm = arm == net.minecraft.world.entity.HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
            ModelPart playerArm = arm == net.minecraft.world.entity.HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
            armorArm.copyFrom(playerArm);
            armorArm.xRot = 0.0F;

            renderEquipmentLayers(poseStack, buffer, combinedLight, armor, armorArm);
            //? if >= 1.20 && <= 1.20.1 {
            /^net.minecraft.world.item.armortrim.ArmorTrim.getTrim(net.minecraft.client.Minecraft.getInstance().level.registryAccess(), armor).ifPresent(
                    armorTrim -> renderArmorTrim(poseStack, buffer, combinedLight, armorTrim, (net.minecraft.world.item.ArmorItem) armor.getItem(), armorArm));^///?}
            renderGlintIfNeeded(poseStack, buffer, combinedLight, armor, armorArm);
        }
    }

    private static void renderEquipmentLayers(PoseStack matrices, MultiBufferSource vertexConsumers,
                                       int light, ItemStack armor, ModelPart armorArm) {
        net.minecraft.world.item.ArmorItem armorItem = (net.minecraft.world.item.ArmorItem) armor.getItem();

        if (armorItem instanceof net.minecraft.world.item.DyeableArmorItem dyeableArmorItem) {
            int color = dyeableArmorItem.getColor(armor);
            float r = (color >> 16 & 255) / 255.0F;
            float g = (color >> 8 & 255) / 255.0F;
            float b = (color & 255) / 255.0F;
            renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, r, g, b, null);
            renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, 1.0F, 1.0F, 1.0F, "overlay");
        } else {
            renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, 1.0F, 1.0F, 1.0F, null);
        }
    }

    private static void renderArmorLayer(PoseStack matrices, MultiBufferSource vertexConsumers, int light,
                                  net.minecraft.world.item.ArmorItem armorItem, ModelPart armorPart, float r, float g, float b, String overlay) {
        net.minecraft.resources.ResourceLocation armorTexture = getArmorTexture(armorItem, overlay);
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(RenderType.armorCutoutNoCull(armorTexture));
        armorPart.render(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, r, g, b, 1.0F);
    }

    private static net.minecraft.resources.ResourceLocation getArmorTexture(net.minecraft.world.item.ArmorItem armorItem, String overlay) {
        String path = "textures/models/armor/" + armorItem.getMaterial().getName() + "_layer_1" +
                (overlay == null ? "" : "_" + overlay) + ".png";
        return new net.minecraft.resources.ResourceLocation(path);
    }

    //? if >= 1.20 && <= 1.20.1 {
    /^private static void renderArmorTrim(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, net.minecraft.world.item.armortrim.ArmorTrim armorTrim, net.minecraft.world.item.ArmorItem armorItem, ModelPart humanoidModel) {
        net.minecraft.client.renderer.texture.TextureAtlasSprite textureAtlasSprite = net.minecraft.client.Minecraft.getInstance().getTextureAtlas(net.minecraft.client.renderer.Sheets.ARMOR_TRIMS_SHEET)
                .apply(armorTrim.outerTexture(armorItem.getMaterial()));
        VertexConsumer vertexConsumer = textureAtlasSprite.wrap(multiBufferSource.getBuffer(net.minecraft.client.renderer.Sheets.armorTrimsSheet()));
        humanoidModel.render(poseStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY, 1.0F, 1.0F, 1.0F, 1.0F);
    }^///?}
    *///?}

    //? if 1.21 || 1.21.1 {
    public static void renderArmor(net.minecraft.class_591 playerModel, class_4587 poseStack, class_4597 buffer, int combinedLight, net.minecraft.class_742 player, net.minecraft.class_1306 arm) {
        if (player.method_5767()) return;
        class_1799 armor = ArmorRendererRegistry.getChestplate(player);
        if (armor.method_7960() || armor.method_31574(net.minecraft.class_1802.field_8162) || !(armor.method_7909() instanceof net.minecraft.class_1738)) return;

        playerModel.field_3447 = 0.0F;
        playerModel.field_3400 = false;
        playerModel.field_3396 = 0.0F;
        playerModel.method_17087(player, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F);

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);

        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, arm, playerModel);
        } else {
            net.minecraft.class_572<net.minecraft.class_1309> armorModel = new net.minecraft.class_572<>(
                    net.minecraft.class_572.method_32011(new net.minecraft.class_5605(1.0f), 0.0f).method_32111().method_32112(64, 32)
            );
            playerModel.method_2818(armorModel);
            class_630 armorArm = arm == net.minecraft.class_1306.field_6182 ? armorModel.field_27433 : armorModel.field_3401;
            class_630 playerArm = arm == net.minecraft.class_1306.field_6182 ? ((net.minecraft.class_591<?>) playerModel).field_27433 : ((net.minecraft.class_591<?>) playerModel).field_3401;
            armorArm.method_17138(playerArm);
            armorArm.field_3654 = 0.0F;

            net.minecraft.class_1738 armorItem = (net.minecraft.class_1738) armor.method_7909();
            renderEquipmentLayers(poseStack, buffer, combinedLight, armor, armorItem, armorArm);
            renderArmorTrim(poseStack, buffer, combinedLight, armor, armorItem, armorArm);
            renderGlintIfNeeded(poseStack, buffer, combinedLight, armor, armorArm);
        }
    }

    private static void renderEquipmentLayers(class_4587 matrices, class_4597 vertexConsumers,
                                              int light, class_1799 armor, net.minecraft.class_1738 armorItem, class_630 armorArm) {
        net.minecraft.class_1741 armorMaterial = armorItem.method_7686().comp_349();
        if (!armorMaterial.comp_2302().isEmpty()) {
            int dyeColor = armor.method_31573(net.minecraft.class_3489.field_48803) ? net.minecraft.class_9282.method_57470(armor, 0) : 0;
            boolean hasFoil = armor.method_7958();

            for (net.minecraft.class_1741.class_9196 layer : armorMaterial.comp_2302()) {
                int color = getColorForLayer(layer, dyeColor, armor);
                if (color != 0) {
                    net.minecraft.class_2960 texture = layer.method_56693(false);
                    class_4588 vertexConsumer = net.minecraft.class_918.method_27952(vertexConsumers, class_1921.method_25448(texture), hasFoil);
                    armorArm.method_22699(matrices, vertexConsumer, light, class_4608.field_21444, color);
                    hasFoil = false;
                }
            }
        }
    }

    private static int getColorForLayer(net.minecraft.class_1741.class_9196 layer, int dyeColor, class_1799 armor) {
        var dyeable = layer.method_56692();
        if (dyeable) {
            int defaultColor = net.minecraft.class_5253.class_5254.method_57174(net.minecraft.class_9282.method_57470(armor, -6265536));
            return dyeColor != 0 ? dyeColor : defaultColor;
        }
        return -1;
    }

    private static void renderArmorTrim(class_4587 matrices, class_4597 vertexConsumers,
                                        int light, class_1799 armor, net.minecraft.class_1738 armorItem, class_630 armorArm) {
        net.minecraft.class_8053 trim = armor.method_57824(net.minecraft.class_9334.field_49607);
        if (trim != null) {
            net.minecraft.class_1058 sprite = net.minecraft.class_310.method_1551().method_1549(net.minecraft.class_4722.field_42071)
                    .apply(trim.method_48436(armorItem.method_7686()));
            class_4588 trimVertexConsumer = sprite.method_24108(
                    vertexConsumers.getBuffer(net.minecraft.class_4722.method_48480((trim.method_48424().comp_349()).comp_1905())));
            armorArm.method_22698(matrices, trimVertexConsumer, light, class_4608.field_21444);
        }
    }
    //?}


    //? if 1.21.2 || 1.21.3 {
    /*public static void renderArmor(net.minecraft.client.model.EntityModel entityModel, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, net.minecraft.world.entity.HumanoidArm arm, boolean isSleeveVisible) {
        net.minecraft.client.player.LocalPlayer player = net.minecraft.client.Minecraft.getInstance().player;
        if (player.isInvisible()) return;
        ItemStack armor = player.getInventory().getArmor(2);
        if (armor.isEmpty() || armor.is(net.minecraft.world.item.Items.AIR) || !(armor.getItem() instanceof net.minecraft.world.item.ArmorItem)) return;
        net.minecraft.world.item.equipment.Equippable equippable = armor.get(net.minecraft.core.component.DataComponents.EQUIPPABLE);

        net.minecraft.client.model.PlayerModel playerModel = (net.minecraft.client.model.PlayerModel) entityModel;

        ModelPart armModel = arm == net.minecraft.world.entity.HumanoidArm.RIGHT ? playerModel.rightArm : playerModel.leftArm;
        armModel.resetPose();
        armModel.visible = true;
        playerModel.leftSleeve.visible = isSleeveVisible;
        playerModel.rightSleeve.visible = isSleeveVisible;
        playerModel.leftArm.zRot = -0.1F;
        playerModel.rightArm.zRot = 0.1F;

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);

        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, arm, (net.minecraft.client.model.HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState>) entityModel);
        } else {
            net.minecraft.client.model.HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> armorModel = new net.minecraft.client.model.HumanoidModel<>(
                    net.minecraft.client.model.HumanoidModel.createMesh(new net.minecraft.client.model.geom.builders.CubeDeformation(1.0f), 0.0f).getRoot().bake(64, 32)
            );
            playerModel.copyPropertiesTo(playerModel);

            ModelPart armorArm = arm == net.minecraft.world.entity.HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
            ModelPart playerArm = arm == net.minecraft.world.entity.HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
            armorArm.copyFrom(playerArm);
            armorArm.xRot = 0.0F;

            renderEquipmentLayers(poseStack, buffer, armor, equippable, armorArm, combinedLight);
            renderArmorTrim(poseStack, buffer, armor, equippable, armorArm, combinedLight);
            renderGlintIfNeeded(poseStack, buffer, combinedLight, armor, armorArm);
        }
    }

    private static void renderEquipmentLayers(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, net.minecraft.world.item.equipment.Equippable equippable, ModelPart armorArm, int light) {
        net.minecraft.resources.ResourceLocation modelId = equippable.model().orElseThrow();
        java.util.List<net.minecraft.world.item.equipment.EquipmentModel.Layer> layers = net.minecraft.client.Minecraft.getInstance().getEquipmentModels().get(modelId).getLayers(net.minecraft.world.item.equipment.EquipmentModel.LayerType.HUMANOID);

        if (!layers.isEmpty()) {
            int dyeColor = chestplate.is(net.minecraft.tags.ItemTags.DYEABLE) ? net.minecraft.world.item.component.DyedItemColor.getOrDefault(chestplate, 0) : 0;
            boolean hasFoil = chestplate.hasFoil();

            for (net.minecraft.world.item.equipment.EquipmentModel.Layer layer : layers) {
                int color = getColorForLayer(layer, dyeColor);
                if (color != 0) {
                    net.minecraft.resources.ResourceLocation texture = layer.getTextureLocation(net.minecraft.world.item.equipment.EquipmentModel.LayerType.HUMANOID);
                    VertexConsumer vertexConsumer = net.minecraft.client.renderer.entity.ItemRenderer.getArmorFoilBuffer(vertexConsumers, RenderType.armorCutoutNoCull(texture), hasFoil);
                    armorArm.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
                    hasFoil = false;
                }
            }
        }
    }

    private static int getColorForLayer(net.minecraft.world.item.equipment.EquipmentModel.Layer layer, int dyeColor) {
        var dyeable = layer.dyeable();
        if (dyeable.isPresent()) {
            int defaultColor = dyeable.get().colorWhenUndyed().map(color -> 0xFF000000 | color).orElse(0);
            return dyeColor != 0 ? dyeColor : defaultColor;
        }
        return -1;
    }

    private static void renderArmorTrim(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, net.minecraft.world.item.equipment.Equippable equippable, ModelPart armorArm, int light) {
        net.minecraft.world.item.equipment.trim.ArmorTrim trim = chestplate.get(net.minecraft.core.component.DataComponents.TRIM);
        if (trim != null) {
            net.minecraft.resources.ResourceLocation modelId = equippable.model().orElseThrow();
            net.minecraft.resources.ResourceLocation trimTextureId = trim.getTexture(net.minecraft.world.item.equipment.EquipmentModel.LayerType.HUMANOID, modelId);
            net.minecraft.client.renderer.texture.TextureAtlasSprite trimSprite = net.minecraft.client.Minecraft.getInstance().getTextureAtlas(net.minecraft.client.renderer.Sheets.ARMOR_TRIMS_SHEET).apply(trimTextureId);
            VertexConsumer trimConsumer = trimSprite.wrap(vertexConsumers.getBuffer(net.minecraft.client.renderer.Sheets.armorTrimsSheet(trim.pattern().value().decal())));
            armorArm.render(poseStack, trimConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }
    *///?}

    //? if >= 1.21.5 {
    /*public static void renderArmor(EntityModel entityModel, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, HumanoidArm humanoidArm, boolean isSleeveVisible) {
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack armor = ArmorRendererRegistry.getChestplate(player);
        if (armor.isEmpty()) return;

        PlayerModel playerModel = (PlayerModel) entityModel;

        ModelPart armModel = humanoidArm == HumanoidArm.RIGHT ? playerModel.rightArm : playerModel.leftArm;
        armModel.resetPose();
        armModel.visible = true;
        playerModel.leftSleeve.visible = isSleeveVisible;
        playerModel.rightSleeve.visible = isSleeveVisible;
        playerModel.leftArm.zRot = -0.1F;
        playerModel.rightArm.zRot = 0.1F;

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);
        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, humanoidArm, (HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState>) entityModel);
        } else {
            net.minecraft.world.item.equipment.Equippable equippable = armor.get(net.minecraft.core.component.DataComponents.EQUIPPABLE);
            if (equippable != null && equippable.assetId().isPresent() && equippable.slot() == EquipmentSlot.CHEST) {
                renderEquipment(poseStack, buffer, player, humanoidArm, combinedLight, armor);
            }
        }
    }

    @Unique
    private static void renderEquipment(PoseStack poseStack, MultiBufferSource vertexConsumers, LocalPlayer player, HumanoidArm arm, int light, ItemStack chestplate) {
        net.minecraft.world.item.equipment.Equippable equippable = chestplate.get(net.minecraft.core.component.DataComponents.EQUIPPABLE);
        ModelPart armorArm = setupArmorModel(player, arm);
        renderEquipmentLayers(poseStack, vertexConsumers, chestplate, equippable, armorArm, light);
        renderTrim(poseStack, vertexConsumers, chestplate, equippable, armorArm, light);
        renderGlintIfNeeded(poseStack, vertexConsumers, light, chestplate, armorArm);
    }

    @Unique
    private static ModelPart setupArmorModel(LocalPlayer player, HumanoidArm arm) {
        PlayerRenderer playerRenderer = (PlayerRenderer) Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(player);
        PlayerModel playerModel = playerRenderer.getModel();

        HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> armorModel = new HumanoidModel<>(
                HumanoidModel.createMesh(new CubeDeformation(1.0f), 0.0f).getRoot().bake(64, 32)
        );

        ModelPart armorArm = arm == HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
        ModelPart playerArm = arm == HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
        armorArm.copyFrom(playerArm);

        return armorArm;
    }

    @Unique
    private static void renderEquipmentLayers(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, net.minecraft.world.item.equipment.Equippable equippable, ModelPart armorArm, int light) {
        ResourceKey<net.minecraft.world.item.equipment.EquipmentAsset> assetId = equippable.assetId().orElseThrow();
        List<net.minecraft.client.resources.model.EquipmentClientInfo.Layer> layers = ((com.github.razorplay01.ismah.common.mixin.EntityRenderDispatcherAccesor) Minecraft.getInstance().getEntityRenderDispatcher())
                .getEquipmentAssetManager()
                .get(assetId)
                .getLayers(net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID);

        if (!layers.isEmpty()) {
            int dyeColor = chestplate.is(ItemTags.DYEABLE) ? net.minecraft.world.item.component.DyedItemColor.getOrDefault(chestplate, 0) : 0;
            boolean hasFoil = chestplate.hasFoil();

            for (net.minecraft.client.resources.model.EquipmentClientInfo.Layer layer : layers) {
                int color = getColorForLayer(layer, dyeColor);
                if (color != 0) {
                    ResourceLocation texture = layer.getTextureLocation(net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID);
                    VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer(vertexConsumers, RenderType.armorCutoutNoCull(texture), hasFoil);
                    armorArm.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
                    hasFoil = false;
                }
            }
        }
    }

    @Unique
    private static int getColorForLayer(net.minecraft.client.resources.model.EquipmentClientInfo.Layer layer, int dyeColor) {
        var dyeable = layer.dyeable();
        if (dyeable.isPresent()) {
            int defaultColor = dyeable.get().colorWhenUndyed().map(color -> 0xFF000000 | color).orElse(0);
            return dyeColor != 0 ? dyeColor : defaultColor;
        }
        return -1;
    }

    @Unique
    private static void renderTrim(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, net.minecraft.world.item.equipment.Equippable equippable, ModelPart armorArm, int light) {
        net.minecraft.world.item.equipment.trim.ArmorTrim trim = chestplate.get(net.minecraft.core.component.DataComponents.TRIM);
        if (trim != null) {
            ResourceKey<net.minecraft.world.item.equipment.EquipmentAsset> assetId = equippable.assetId().orElseThrow();

            ResourceLocation patternAssetId = trim.pattern().value().assetId();
            String materialSuffix = getColorPaletteSuffix(trim.material(), assetId);
            ResourceLocation trimTextureId = patternAssetId.withPath(p -> "trims/entity/" + net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID.getSerializedName() + "/" + p + "_" + materialSuffix);

            TextureAtlasSprite trimSprite = Minecraft.getInstance().getTextureAtlas(Sheets.ARMOR_TRIMS_SHEET).apply(trimTextureId);
            VertexConsumer trimConsumer = trimSprite.wrap(vertexConsumers.getBuffer(Sheets.armorTrimsSheet(trim.pattern().value().decal())));
            armorArm.render(poseStack, trimConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }

    @Unique
    private static String getColorPaletteSuffix(Holder<net.minecraft.world.item.equipment.trim.TrimMaterial> trimMaterial, ResourceKey<net.minecraft.world.item.equipment.EquipmentAsset> equipmentAsset) {
        net.minecraft.world.item.equipment.trim.MaterialAssetGroup assets = trimMaterial.value().assets();
        net.minecraft.world.item.equipment.trim.MaterialAssetGroup.AssetInfo assetInfo = assets.assetId(equipmentAsset);
        return assetInfo.suffix();
    }
    *///?}

    private static void renderGlintIfNeeded(class_4587 matrices, class_4597 vertexConsumers,
                                            int light, class_1799 armor, class_630 armorArm) {
        if (armor.method_7958()) {
            class_4588 glintConsumer = vertexConsumers.getBuffer(class_1921.method_23591());
            armorArm.method_22698(matrices, glintConsumer, light, class_4608.field_21444);
        }
    }


    //? if 1.21.4 {
    /*public static void renderArmor(EntityModel entityModel, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, HumanoidArm humanoidArm, boolean isSleeveVisible) {
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack armor = ArmorRendererRegistry.getChestplate(player);
        if (armor.isEmpty()) return;

        PlayerModel playerModel = (PlayerModel) entityModel;

        ModelPart armModel = humanoidArm == HumanoidArm.RIGHT ? playerModel.rightArm : playerModel.leftArm;
        armModel.resetPose();
        armModel.visible = true;
        playerModel.leftSleeve.visible = isSleeveVisible;
        playerModel.rightSleeve.visible = isSleeveVisible;
        playerModel.leftArm.zRot = -0.1F;
        playerModel.rightArm.zRot = 0.1F;

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);
        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, humanoidArm, (HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState>) entityModel);
        } else {
            net.minecraft.world.item.equipment.Equippable equippable = armor.get(net.minecraft.core.component.DataComponents.EQUIPPABLE);
            if (equippable != null && equippable.assetId().isPresent() && equippable.slot() == EquipmentSlot.CHEST) {
                renderEquipment(poseStack, buffer, player, humanoidArm, combinedLight, armor);
            }
        }
    }

    @Unique
    private static void renderEquipment(PoseStack poseStack, MultiBufferSource vertexConsumers, LocalPlayer player, HumanoidArm arm, int light, ItemStack chestplate) {
        net.minecraft.world.item.equipment.Equippable equippable = chestplate.get(net.minecraft.core.component.DataComponents.EQUIPPABLE);
        ModelPart armorArm = setupArmorModel(player, arm);
        renderEquipmentLayers(poseStack, vertexConsumers, chestplate, equippable, armorArm, light);
        renderTrim(poseStack, vertexConsumers, chestplate, armorArm, light);
        renderGlintIfNeeded(poseStack, vertexConsumers, light, chestplate, armorArm);
    }

    @Unique
    private static ModelPart setupArmorModel(LocalPlayer player, HumanoidArm arm) {
        PlayerRenderer playerRenderer = (PlayerRenderer) Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(player);
        PlayerModel playerModel = playerRenderer.getModel();

        HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> armorModel = new HumanoidModel<>(
                HumanoidModel.createMesh(new CubeDeformation(1.0f), 0.0f).getRoot().bake(64, 32)
        );

        ModelPart armorArm = arm == HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
        ModelPart playerArm = arm == HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
        armorArm.copyFrom(playerArm);

        return armorArm;
    }

    @Unique
    private static void renderEquipmentLayers(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, net.minecraft.world.item.equipment.Equippable equippable, ModelPart armorArm, int light) {
        ResourceKey<net.minecraft.world.item.equipment.EquipmentAsset> assetId = equippable.assetId().orElseThrow();
        List<net.minecraft.client.resources.model.EquipmentClientInfo.Layer> layers =
                ((com.github.razorplay01.ismah.common.mixin.EntityRenderDispatcherAccesor) Minecraft.getInstance().getEntityRenderDispatcher())
                .getEquipmentAssetManager()
                .get(assetId)
                .getLayers(net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID);

        if (!layers.isEmpty()) {
            int dyeColor = chestplate.is(ItemTags.DYEABLE) ? net.minecraft.world.item.component.DyedItemColor.getOrDefault(chestplate, 0) : 0;
            boolean hasFoil = chestplate.hasFoil();

            for (net.minecraft.client.resources.model.EquipmentClientInfo.Layer layer : layers) {
                int color = getColorForLayer(layer, dyeColor);
                if (color != 0) {
                    ResourceLocation texture = layer.getTextureLocation(net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID);
                    VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer(vertexConsumers, RenderType.armorCutoutNoCull(texture), hasFoil);
                    armorArm.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
                    hasFoil = false;
                }
            }
        }
    }

    @Unique
    private static int getColorForLayer(net.minecraft.client.resources.model.EquipmentClientInfo.Layer layer, int dyeColor) {
        var dyeable = layer.dyeable();
        if (dyeable.isPresent()) {
            int defaultColor = dyeable.get().colorWhenUndyed().map(color -> 0xFF000000 | color).orElse(0);
            return dyeColor != 0 ? dyeColor : defaultColor;
        }
        return -1;
    }

    private static void renderTrim(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, ModelPart armorArm, int light) {
        net.minecraft.world.item.equipment.trim.ArmorTrim trim = chestplate.get(net.minecraft.core.component.DataComponents.TRIM);
        if (trim != null) {
            net.minecraft.resources.ResourceLocation trimTextureId = trim.pattern().value().assetId();
            net.minecraft.client.renderer.texture.TextureAtlasSprite trimSprite = net.minecraft.client.Minecraft.getInstance().getTextureAtlas(net.minecraft.client.renderer.Sheets.ARMOR_TRIMS_SHEET).apply(trimTextureId);
            VertexConsumer trimConsumer = trimSprite.wrap(vertexConsumers.getBuffer(net.minecraft.client.renderer.Sheets.armorTrimsSheet(trim.pattern().value().decal())));
            armorArm.render(poseStack, trimConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }
    *///?}
}
