/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.client.util;

import com.github.razorplay01.ismah.client.api.ArmorRendererRegistry;
import com.github.razorplay01.ismah.client.api.CustomArmorRenderer;
import com.github.razorplay01.ismah.client.config.ModConfig;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4057;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5605;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_7923;

public class RenderUtil {
    private RenderUtil() {
    }

    public static void renderArmor(class_591 playerModel, class_4587 poseStack, class_4597 buffer, int combinedLight, class_742 player, class_1306 arm) {
        if (player.method_5767()) {
            return;
        }
        class_1799 armor = ArmorRendererRegistry.getChestplate((class_1657)player);
        if (armor.method_7960() || armor.method_31574(class_1802.field_8162) || !(armor.method_7909() instanceof class_1738)) {
            return;
        }
        class_2960 itemId = class_7923.field_41178.method_10221((Object)armor.method_7909());
        if (ModConfig.isArmorBlacklisted(itemId)) {
            return;
        }
        class_630 armModel = arm == class_1306.field_6183 ? playerModel.field_3401 : playerModel.field_27433;
        armModel.method_41923();
        armModel.field_3665 = true;
        playerModel.field_27433.field_3674 = -0.1f;
        playerModel.field_3401.field_3674 = 0.1f;
        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);
        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, arm, (class_572<class_1309>)playerModel);
        } else {
            class_572 armorModel = new class_572(class_572.method_32011((class_5605)new class_5605(1.0f), (float)0.0f).method_32111().method_32112(64, 32));
            playerModel.method_2818((class_572)playerModel);
            class_630 armorArm = arm == class_1306.field_6182 ? armorModel.field_27433 : armorModel.field_3401;
            class_630 playerArm = arm == class_1306.field_6182 ? playerModel.field_27433 : playerModel.field_3401;
            armorArm.method_17138(playerArm);
            armorArm.field_3654 = 0.0f;
            RenderUtil.renderEquipmentLayers(poseStack, buffer, combinedLight, armor, armorArm);
            RenderUtil.renderGlintIfNeeded(poseStack, buffer, combinedLight, armor, armorArm);
        }
    }

    private static void renderEquipmentLayers(class_4587 matrices, class_4597 vertexConsumers, int light, class_1799 armor, class_630 armorArm) {
        class_1738 armorItem = (class_1738)armor.method_7909();
        if (armorItem instanceof class_4057) {
            class_4057 dyeableArmorItem = (class_4057)armorItem;
            int color = dyeableArmorItem.method_7800(armor);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            RenderUtil.renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, r, g, b, null);
            RenderUtil.renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, 1.0f, 1.0f, 1.0f, "overlay");
        } else {
            RenderUtil.renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, 1.0f, 1.0f, 1.0f, null);
        }
    }

    private static void renderArmorLayer(class_4587 matrices, class_4597 vertexConsumers, int light, class_1738 armorItem, class_630 armorPart, float r, float g, float b, String overlay) {
        class_2960 armorTexture = RenderUtil.getArmorTexture(armorItem, overlay);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_25448((class_2960)armorTexture));
        armorPart.method_22699(matrices, vertexConsumer, light, class_4608.field_21444, r, g, b, 1.0f);
    }

    private static class_2960 getArmorTexture(class_1738 armorItem, String overlay) {
        String materialName = armorItem.method_7686().method_7694();
        String namespace = "minecraft";
        String baseName = materialName;
        if (materialName.contains(":")) {
            String[] parts = materialName.split(":", 2);
            namespace = parts[0];
            baseName = parts[1];
        }
        String path = "textures/models/armor/" + baseName + "_layer_1" + (String)(overlay == null ? "" : "_" + overlay) + ".png";
        return new class_2960(namespace, path);
    }

    private static void renderGlintIfNeeded(class_4587 matrices, class_4597 vertexConsumers, int light, class_1799 armor, class_630 armorArm) {
        if (armor.method_7958()) {
            class_4588 glintConsumer = vertexConsumers.getBuffer(class_1921.method_23591());
            armorArm.method_22698(matrices, glintConsumer, light, class_4608.field_21444);
        }
    }
}

